/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.Set;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.BlockSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6364")
public class ShortBackupRetentionCheck
extends AbstractNewResourceCheck {
    public static final String MESSAGE = "Make sure that defining a short backup retention duration is safe here.";
    public static final String OMITTING_MESSAGE = "Omitting \"%s\" results in a short backup retention duration. Make sure it is safe here.";
    public static final int DEFAULT = 7;
    private static final Set<String> ENGINES_EXCEPTION = Set.of("aurora", "aurora-mysql", "aurora-postgresql");
    @RuleProperty(key="backup_retention_duration", defaultValue="7", description="Minimum backup retention duration in days")
    int backupRetentionDuration = 7;

    @Override
    protected void registerResourceConsumer() {
        this.register("aws_db_instance", (ResourceSymbol resource) -> {
            if (resource.attribute("source_db_instance_identifier").isAbsent() && !resource.attribute("engine").is(ShortBackupRetentionCheck.isEngineException())) {
                this.checkAwsRetentionRate((ResourceSymbol)((Object)resource));
            }
        });
        this.register("aws_rds_cluster", this::checkAwsRetentionRate);
        this.register("azurerm_backup_policy_file_share", (ResourceSymbol resource) -> resource.block("retention_daily").attribute("count").reportIf(ExpressionPredicate.lessThan(this.backupRetentionDuration), MESSAGE, new SecondaryLocation[0]));
        this.register("azurerm_cosmosdb_account", (ResourceSymbol resource) -> ((AttributeSymbol)((BlockSymbol)resource.block("backup").reportIfAbsent(String.format(OMITTING_MESSAGE, "backup.retention_in_hours"), new SecondaryLocation[0])).attribute("retention_in_hours").reportIfAbsent(OMITTING_MESSAGE, new SecondaryLocation[0])).reportIf(ExpressionPredicate.lessThan(this.backupRetentionDuration * 24), MESSAGE, new SecondaryLocation[0]));
        this.register("azurerm_app_service", (ResourceSymbol resource) -> {
            BlockSymbol backup = (BlockSymbol)resource.block("backup").reportIfAbsent(OMITTING_MESSAGE, new SecondaryLocation[0]);
            AttributeSymbol enabled = backup.attribute("enabled");
            if (enabled.isPresent()) {
                enabled.reportIf(ExpressionPredicate.isFalse(), "Make sure disabling backup is safe here.", new SecondaryLocation[0]);
                if (enabled.is(ExpressionPredicate.isTrue())) {
                    backup.block("schedule").attribute("retention_period_in_days").reportIf(ExpressionPredicate.lessThan(this.backupRetentionDuration), MESSAGE, new SecondaryLocation[0]);
                }
            }
        });
    }

    private static Predicate<ExpressionTree> isEngineException() {
        return expr -> TextUtils.getValue((Tree)expr).filter(ENGINES_EXCEPTION::contains).isPresent();
    }

    private void checkAwsRetentionRate(ResourceSymbol resource) {
        AttributeSymbol retentionPeriod = (AttributeSymbol)resource.attribute("backup_retention_period").reportIf(ExpressionPredicate.lessThan(this.backupRetentionDuration), MESSAGE, new SecondaryLocation[0]);
        if (retentionPeriod.isAbsent() && this.backupRetentionDuration != 1) {
            retentionPeriod.reportIfAbsent(OMITTING_MESSAGE, new SecondaryLocation[0]);
        }
    }
}

