/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.aws;

import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.BlockSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

public class AwsPublicNetworkAccessCheckPart
extends AbstractNewResourceCheck {
    private static final String SECONDARY_INSTANCE_MESSAGE = "Related instance";
    private static final String SECONDARY_TEMPLATE_MESSAGE = "Related template";

    @Override
    protected void registerResourceConsumer() {
        this.register("aws_dms_replication_instance", (ResourceSymbol resource) -> ((AttributeSymbol)resource.attribute("publicly_accessible").reportIfAbsent("Omitting \"%s\" allows network access from the Internet. Make sure it is safe here.", new SecondaryLocation[0])).reportIf(ExpressionPredicate.isTrue(), "Make sure allowing public network access is safe here.", new SecondaryLocation[]{resource.toSecondary(SECONDARY_INSTANCE_MESSAGE)}));
        this.register("aws_instance", (ResourceSymbol resource) -> ((AttributeSymbol)resource.attribute("associate_public_ip_address").reportIfAbsent("Omitting \"%s\" allows network access from the Internet. Make sure it is safe here.", new SecondaryLocation[0])).reportIf(ExpressionPredicate.isTrue(), "Make sure allowing public network access is safe here.", new SecondaryLocation[]{resource.toSecondary(SECONDARY_INSTANCE_MESSAGE)}));
        this.register("aws_launch_template", (ResourceSymbol resource) -> ((AttributeSymbol)((BlockSymbol)resource.block("network_interfaces").reportIfAbsent(String.format("Omitting \"%s\" allows network access from the Internet. Make sure it is safe here.", "network_interfaces.associate_public_ip_address"), new SecondaryLocation[0])).attribute("associate_public_ip_address").reportIfAbsent("Omitting \"%s\" allows network access from the Internet. Make sure it is safe here.", new SecondaryLocation[]{resource.toSecondary(SECONDARY_TEMPLATE_MESSAGE)})).reportIf(ExpressionPredicate.isTrue(), "Make sure allowing public network access is safe here.", new SecondaryLocation[]{resource.toSecondary(SECONDARY_TEMPLATE_MESSAGE)}));
    }
}

