/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.BlockSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

public class AzureDisabledLoggingCheckPart
extends AbstractNewResourceCheck {
    @Override
    protected void registerResourceConsumer() {
        this.register(List.of("azurerm_function_app", "azurerm_function_app_slot"), (ResourceSymbol resource) -> resource.attribute("enable_builtin_logging").reportIf(ExpressionPredicate.isFalse(), "Make sure that disabling built-in logging is safe here.", new SecondaryLocation[0]));
        this.register("azurerm_automation_runbook", (ResourceSymbol resource) -> ((AttributeSymbol)resource.attribute("log_progress").reportIfAbsent("Make sure that omitting the activation of progress logging is safe here.", new SecondaryLocation[0])).reportIf(ExpressionPredicate.isFalse(), "Make sure that disabling progress logging is safe here.", new SecondaryLocation[0]));
        this.register(List.of("azurerm_app_service", "azurerm_app_service_slot"), AzureDisabledLoggingCheckPart::checkAppService);
        this.register("azurerm_container_group", (ResourceSymbol resource) -> resource.block("diagnostic").reportIfAbsent("This resource does not have diagnostic logs enabled. Make sure it is safe here.", new SecondaryLocation[0]));
        this.register("azurerm_storage_account", AzureDisabledLoggingCheckPart::checkStorageAccount);
    }

    private static void checkAppService(ResourceSymbol resource) {
        boolean isApplicationLogDisabled;
        BlockSymbol logs = resource.block("logs");
        if (logs.isAbsent()) {
            resource.report("Make sure that omitting the \"logs\" block is safe here.", new SecondaryLocation[0]);
            return;
        }
        BlockSymbol httpLogs = logs.block("http_logs");
        BlockSymbol applicationLogs = logs.block("application_logs");
        boolean isHttpLogsDisabled = httpLogs.isAbsent();
        if (isHttpLogsDisabled && applicationLogs.isAbsent()) {
            logs.report("Make sure that omitting http and application logging blocks is safe here.", new SecondaryLocation[0]);
            return;
        }
        AttributeSymbol fileSystemLevel = applicationLogs.attribute("file_system_level");
        BlockSymbol azureBlobStorage = applicationLogs.block("azure_blob_storage");
        boolean isFileSystemLogDisabled = fileSystemLevel.isAbsent() || fileSystemLevel.is(ExpressionPredicate.equalTo("Off"));
        boolean isBlobStorageLogDisabled = azureBlobStorage.isAbsent() || azureBlobStorage.attribute("level").is(ExpressionPredicate.equalTo("Off"));
        boolean bl = isApplicationLogDisabled = isFileSystemLogDisabled && isBlobStorageLogDisabled;
        if (isHttpLogsDisabled && isApplicationLogDisabled) {
            logs.report("Make sure that disabling logging is safe here.", new SecondaryLocation[0]);
        } else if (isHttpLogsDisabled) {
            logs.report("Make sure that omitting HTTP logs is safe here.", new SecondaryLocation[0]);
        } else if (isApplicationLogDisabled) {
            applicationLogs.report("Make sure that deactivating application logs is safe here.", new SecondaryLocation[0]);
        }
    }

    private static void checkStorageAccount(ResourceSymbol resource) {
        if (resource.attribute("account_kind").is(ExpressionPredicate.equalTo("BlobStorage"))) {
            return;
        }
        BlockSymbol logging = (BlockSymbol)((BlockSymbol)resource.block("queue_properties").reportIfAbsent("Make sure that omitting to log is safe here.", new SecondaryLocation[0])).block("logging").reportIfAbsent("Make sure that omitting to log is safe here.", new SecondaryLocation[0]);
        List<AttributeSymbol> disabled = Stream.of("delete", "read", "write").map(logging::attribute).filter(setting -> setting.is(ExpressionPredicate.isFalse())).collect(Collectors.toList());
        long disabledLoggings = disabled.size();
        if (disabledLoggings == 3L) {
            logging.report("Make sure that disabling logging is safe here.", new SecondaryLocation[0]);
            return;
        }
        if (disabledLoggings == 2L) {
            logging.report("Make sure that partially enabling logging is safe here.", new SecondaryLocation[0]);
            return;
        }
        disabled.forEach(setting -> setting.report("Make sure that partially enabling logging is safe here.", new SecondaryLocation[0]));
    }
}

