/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6379")
public class ResourceSpecificAdminAccountCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that enabling an administrative account or administrative permissions is safe here.";

    @Override
    protected void registerResourceChecks() {
        this.register(ResourceSpecificAdminAccountCheck::checkContainerRegistry, "azurerm_container_registry");
        this.register(ResourceSpecificAdminAccountCheck::checkBatchPool, "azurerm_batch_pool");
    }

    private static void checkContainerRegistry(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get((Tree)resource, (String)"admin_enabled", AttributeTree.class).filter(attr -> TextUtils.isValueTrue((Tree)attr.value())).ifPresent(attr -> ctx.reportIssue((HasTextRange)attr, MESSAGE));
    }

    private static void checkBatchPool(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get((Tree)resource, (String)"start_task", BlockTree.class).flatMap(startTask -> PropertyUtils.get((Tree)startTask, (String)"user_identity", BlockTree.class)).flatMap(userIdentity -> PropertyUtils.get((Tree)userIdentity, (String)"auto_user", BlockTree.class)).flatMap(autoUser -> PropertyUtils.get((Tree)autoUser, (String)"elevation_level", AttributeTree.class)).filter(attr -> TextUtils.isValue((Tree)attr.value(), (String)"Admin").isTrue()).ifPresent(attr -> ctx.reportIssue((HasTextRange)attr, MESSAGE));
    }
}

