/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.gcp;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.checks.policy.IpRestrictedAdminAccessCheckUtils;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

public class GcpIpRestrictedAdminAccessCheckPart
extends AbstractNewResourceCheck {
    private static final Set<String> SENSITIVE_PREFIXES = Set.of("0.0.0.0/0", "::/0", "0::0/0", "::0/0");
    private static final Predicate<ExpressionTree> RANGE_CONTAINS_SENSITIVE_PORTS = range -> TextUtils.matchesValue((Tree)range, IpRestrictedAdminAccessCheckUtils::rangeContainsSshOrRdpPort).isTrue();
    private static final Predicate<ExpressionTree> SENSITIVE_IP_RANGE = range -> TextUtils.matchesValue((Tree)range, SENSITIVE_PREFIXES::contains).isTrue();

    @Override
    protected void registerResourceConsumer() {
        this.register(List.of("google_compute_firewall"), this::checkFirewall);
    }

    private void checkFirewall(ResourceSymbol firewall) {
        if (firewall.attribute("direction").is(ExpressionPredicate.equalTo("EGRESS")) || firewall.attribute("source_tags").isPresent() || firewall.attribute("disabled").is(ExpressionPredicate.isTrue())) {
            return;
        }
        SecondaryLocation[] sensitivePortLocations = (SecondaryLocation[])firewall.blocks("allow").filter(allow -> allow.attribute("protocol").is(ExpressionPredicate.equalTo("tcp"))).flatMap(allow -> allow.list("ports").getItemIf(RANGE_CONTAINS_SENSITIVE_PORTS)).map(sensitivePorts -> new SecondaryLocation((HasTextRange)sensitivePorts, "Related protocol setting.")).toArray(SecondaryLocation[]::new);
        if (sensitivePortLocations.length > 0) {
            firewall.list("source_ranges").reportItemIf(SENSITIVE_IP_RANGE, "Restrict IP addresses authorized to access administration services.", sensitivePortLocations);
        }
    }
}

