/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.gcp;

import java.util.List;
import java.util.Set;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.visitors.TreeContext;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.FileTree;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.gcp.PolicyReferenceCollector;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

public class GcpPrivilegePolicyCheckPart
extends AbstractNewResourceCheck {
    private static final String POLICY_MESSAGE = "Make sure it is safe to give all members full access.";
    private static final String MEMBER_MESSAGE = "Make sure it is safe to grant that member full access.";
    private static final String SECONDARY_MESSAGE = "The policy is used here.";
    private static final String SENSITIVE_ROLES = ".*(?:admin|manager|owner|superuser).*";
    private final PolicyReferenceCollector collector = new PolicyReferenceCollector(IAM_POLICY_RESOURCE_TYPES);
    private static final Set<String> IAM_POLICY_RESOURCE_TYPES = Set.of("google_project_iam_policy", "google_organization_iam_policy", "google_service_account_iam_policy", "google_folder_iam_policy");

    @Override
    public void initialize(InitContext init) {
        super.initialize(init);
        init.register(FileTree.class, (ctx, tree) -> this.collector.scan(new TreeContext(), (Tree)tree));
    }

    @Override
    protected void provideResource(CheckContext ctx, BlockTree blockTree) {
        super.provideResource(ctx, blockTree);
        if (GcpPrivilegePolicyCheckPart.isDataOfType(blockTree, "google_iam_policy")) {
            ResourceSymbol dataData = ResourceSymbol.fromPresent(ctx, blockTree);
            this.collector.checkPolicy(dataData, ExpressionPredicate.matchesPattern(SENSITIVE_ROLES), POLICY_MESSAGE, SECONDARY_MESSAGE);
        }
    }

    @Override
    protected void registerResourceConsumer() {
        this.register(List.of("google_project_iam_binding", "google_organization_iam_binding", "google_service_account_iam_binding", "google_folder_iam_binding"), (ResourceSymbol resource) -> this.checkRole((ResourceSymbol)((Object)resource), POLICY_MESSAGE));
        this.register(List.of("google_project_iam_member", "google_organization_iam_member", "google_service_account_iam_member", "google_folder_iam_member"), (ResourceSymbol resource) -> this.checkRole((ResourceSymbol)((Object)resource), MEMBER_MESSAGE));
    }

    private void checkRole(ResourceSymbol resource, String message) {
        resource.attribute("role").reportIf(ExpressionPredicate.matchesPattern(SENSITIVE_ROLES), message, new SecondaryLocation[0]);
    }
}

