/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.gcp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.FileTree;
import org.sonar.iac.terraform.api.tree.StatementTree;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.BlockSymbol;
import org.sonar.iac.terraform.symbols.ReferenceSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6404")
public class PublicAccessCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "Ensure that granting public access to this resource is safe here.";
    private static final String SECONDARY_MESSAGE = "Excessive granting of permissions.";
    private static final String OMITTING_DNS = "Omitting %s will grant public access to this managed zone. Ensure it is safe here.";
    private static final String OMITTING_KUBERNETES = "Omitting %s grants public access to parts of this cluster. Make sure it is safe here.";
    private static final String MESSAGE_KUBERNETES = "Ensure that granting public access is safe here.";
    private static final String GCP_RESOURCE_PREFIX = "google_";
    private static final List<String> IAM_RESOURCES = List.of("apigee_environment", "api_gateway_api_config", "api_gateway_api", "api_gateway_gateway", "artifact_registry_repository", "bigquery_dataset", "bigquery_table", "bigtable_instance", "bigtable_table", "billing_account", "binary_authorization_attestor", "cloudfunctions_function", "cloud_run_service", "compute_disk", "compute_image", "compute_instance", "compute_machine_image", "compute_region_disk", "compute_subnetwork", "dataproc_cluster", "dataproc_job", "data_catalog_entry_group", "data_catalog_policy_tag", "data_catalog_tag_template", "data_catalog_taxonomy", "endpoints_service", "kms_crypto_key", "kms_key_ring", "healthcare_consent_store", "healthcare_dataset", "healthcare_dicom_store", "healthcare_fhir_store", "healthcare_hl7_v2_store", "iap_app_engine_service", "iap_app_engine_version", "iap_tunnel", "iap_tunnel_instance", "iap_web_backend_service", "iap_web", "iap_web_type_app_engine", "iap_web_type_compute", "notebooks_instance", "notebooks_runtime", "privateca_ca_pool", "pubsub_subscription", "pubsub_topic", "runtimeconfig_config", "secret_manager_secret", "service_directory_namespace", "service_directory_service", "sourcerepo_repository", "spanner_database", "spanner_instance", "storage_bucket", "tags_tag_key", "tags_tag_value", "project", "organization", "service_account", "folder");
    private static final String CONTAINS_SENSITIVE_MEMBER = ".*all(Authenticated)?Users.*";
    private Map<String, BlockSymbol> policyDataCollection = new HashMap<String, BlockSymbol>();

    @Override
    public void initialize(InitContext init) {
        init.register(FileTree.class, this::collectPolicyData);
        super.initialize(init);
    }

    private void collectPolicyData(CheckContext ctx, FileTree file) {
        this.policyDataCollection = file.properties().stream().filter(PublicAccessCheck::isPolicyDataBlock).map(BlockTree.class::cast).collect(Collectors.toMap(data -> String.format("data.google_iam_policy.%s.policy_data", PublicAccessCheck.getName(data)), data -> ResourceSymbol.fromPresent(ctx, data)));
    }

    @Override
    protected void registerResourceConsumer() {
        this.register(PublicAccessCheck.iamResourceNameList("_iam_binding"), (ResourceSymbol resource) -> resource.list("members").reportItemIf(ExpressionPredicate.matchesPattern(CONTAINS_SENSITIVE_MEMBER), MESSAGE, new SecondaryLocation[0]));
        this.register(PublicAccessCheck.iamResourceNameList("_iam_member"), (ResourceSymbol resource) -> resource.attribute("member").reportIf(ExpressionPredicate.matchesPattern(CONTAINS_SENSITIVE_MEMBER), MESSAGE, new SecondaryLocation[0]));
        this.register(List.of("google_storage_default_object_access_control", "google_storage_object_access_control"), (ResourceSymbol resource) -> resource.attribute("entity").reportIf(ExpressionPredicate.matchesPattern("all(Authenticated)?Users"), MESSAGE, new SecondaryLocation[0]));
        this.register("google_bigquery_dataset_access", (ResourceSymbol resource) -> resource.attribute("special_group").reportIf(ExpressionPredicate.matchesPattern("all(Authenticated)?Users"), MESSAGE, new SecondaryLocation[0]));
        this.register(List.of("google_storage_bucket_acl", "google_storage_default_object_acl", "google_storage_object_acl"), (ResourceSymbol resource) -> resource.list("role_entity").reportItemIf(ExpressionPredicate.matchesPattern(".*:all(Authenticated)?Users"), MESSAGE, new SecondaryLocation[0]));
        this.register("google_dns_managed_zone", (ResourceSymbol resource) -> ((AttributeSymbol)resource.attribute("visibility").reportIf(ExpressionPredicate.equalTo("public"), MESSAGE, new SecondaryLocation[0])).reportIfAbsent(OMITTING_DNS, new SecondaryLocation[0]));
        this.register("google_container_cluster", (ResourceSymbol resource) -> {
            BlockSymbol config = resource.block("private_cluster_config");
            config.reportIfAbsent(OMITTING_KUBERNETES, new SecondaryLocation[0]);
            AttributeSymbol nodes = config.attribute("enable_private_nodes");
            AttributeSymbol endpoint = config.attribute("enable_private_endpoint");
            if (nodes.isAbsent() && endpoint.isAbsent()) {
                config.report(String.format(OMITTING_KUBERNETES, "enable_private_nodes and enable_private_endpoint"), new SecondaryLocation[0]);
            } else if (nodes.is(ExpressionPredicate.isFalse()) && endpoint.is(ExpressionPredicate.isFalse())) {
                nodes.report(MESSAGE_KUBERNETES, new SecondaryLocation[]{endpoint.toSecondary(MESSAGE_KUBERNETES)});
            } else {
                Stream.of(nodes, endpoint).forEach(symbol -> ((AttributeSymbol)symbol.reportIf(ExpressionPredicate.isFalse(), MESSAGE_KUBERNETES, new SecondaryLocation[0])).reportIfAbsent(OMITTING_KUBERNETES, new SecondaryLocation[0]));
            }
        });
        this.register(PublicAccessCheck.iamResourceNameList("_iam_policy"), (ResourceSymbol resource) -> {
            ReferenceSymbol reference = resource.reference("policy_data");
            ArrayList sensitiveMemberBindings = new ArrayList();
            reference.resolve(this.policyDataCollection).blocks("binding").forEach(block -> block.list("members").getItemIf(ExpressionPredicate.matchesPattern(CONTAINS_SENSITIVE_MEMBER)).forEach(sensitiveMember -> sensitiveMemberBindings.add(new SecondaryLocation((HasTextRange)sensitiveMember, SECONDARY_MESSAGE))));
            if (!sensitiveMemberBindings.isEmpty()) {
                reference.report(MESSAGE, sensitiveMemberBindings);
            }
        });
    }

    private static List<String> iamResourceNameList(String suffix) {
        return IAM_RESOURCES.stream().map(resourceName -> GCP_RESOURCE_PREFIX + resourceName + suffix).collect(Collectors.toList());
    }

    private static boolean isPolicyDataBlock(StatementTree statement) {
        return statement.is(TerraformTree.Kind.BLOCK) && PublicAccessCheck.isDataOfType((BlockTree)statement, "google_iam_policy") && PublicAccessCheck.getName((BlockTree)statement) != null;
    }

    @CheckForNull
    private static String getName(BlockTree block) {
        return block.labels().size() >= 2 ? block.labels().get(1).value() : null;
    }
}

