/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.symbols;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checkdsl.ContextualTree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.ListSymbol;
import org.sonar.iac.terraform.symbols.ReferenceSymbol;

public class BlockSymbol
extends ContextualTree<BlockSymbol, BlockTree> {
    protected BlockSymbol(CheckContext ctx, BlockTree tree, String name, BlockSymbol parent) {
        super(ctx, (Tree)tree, name, (ContextualTree)parent);
    }

    public static BlockSymbol fromPresent(CheckContext ctx, BlockTree tree, BlockSymbol parent) {
        return new BlockSymbol(ctx, tree, tree.key().value(), parent);
    }

    public static BlockSymbol fromAbsent(CheckContext ctx, String name, BlockSymbol parent) {
        return new BlockSymbol(ctx, null, name, parent);
    }

    public BlockSymbol block(String name) {
        return Optional.ofNullable((BlockTree)this.tree).flatMap(tree -> PropertyUtils.get((Tree)tree, (String)name, BlockTree.class)).map(block -> BlockSymbol.fromPresent(this.ctx, block, this)).orElse(BlockSymbol.fromAbsent(this.ctx, name, this));
    }

    public Stream<BlockSymbol> blocks(String name) {
        return PropertyUtils.getAll((Tree)this.tree, (String)name, BlockTree.class).stream().map(block -> BlockSymbol.fromPresent(this.ctx, block, this));
    }

    public ListSymbol list(String name) {
        return Optional.ofNullable((BlockTree)this.tree).flatMap(tree -> PropertyUtils.get((Tree)tree, (String)name, AttributeTree.class)).map(attribute -> ListSymbol.fromPresent(this.ctx, attribute, this)).orElse(ListSymbol.fromAbsent(this.ctx, name, this));
    }

    public AttributeSymbol attribute(String name) {
        return Optional.ofNullable((BlockTree)this.tree).flatMap(tree -> PropertyUtils.get((Tree)tree, (String)name, AttributeTree.class)).map(attribute -> AttributeSymbol.fromPresent(this.ctx, attribute, this)).orElse(AttributeSymbol.fromAbsent(this.ctx, name, this));
    }

    public ReferenceSymbol reference(String name) {
        return Optional.ofNullable((BlockTree)this.tree).flatMap(tree -> PropertyUtils.get((Tree)tree, (String)name, AttributeTree.class)).map(attribute -> ReferenceSymbol.fromPresent(this.ctx, attribute, this)).orElse(ReferenceSymbol.fromAbsent(this.ctx, name, this));
    }

    public BlockSymbol consume(Consumer<BlockSymbol> consumer) {
        consumer.accept(this);
        return this;
    }

    @Nullable
    protected HasTextRange toHighlight() {
        return this.tree != null ? ((BlockTree)this.tree).key() : null;
    }
}

