/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.symbols;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checkdsl.ContextualListTree;
import org.sonar.iac.common.checkdsl.ContextualTree;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.api.tree.TupleTree;
import org.sonar.iac.terraform.symbols.BlockSymbol;

public class ListSymbol
extends ContextualListTree<ListSymbol, AttributeTree, ExpressionTree> {
    private ListSymbol(CheckContext ctx, @Nullable AttributeTree tree, String name, BlockSymbol parent, List<ExpressionTree> items) {
        super(ctx, (Tree)tree, name, (ContextualTree)parent, items);
    }

    public static ListSymbol fromPresent(CheckContext ctx, AttributeTree tree, BlockSymbol parent) {
        if (tree.value().is(TerraformTree.Kind.TUPLE)) {
            return new ListSymbol(ctx, tree, tree.key().value(), parent, ((TupleTree)tree.value()).elements().trees());
        }
        return new ListSymbol(ctx, tree, tree.key().value(), parent, Collections.emptyList());
    }

    public static ListSymbol fromAbsent(CheckContext ctx, String name, BlockSymbol parent) {
        return new ListSymbol(ctx, null, name, parent, Collections.emptyList());
    }

    public boolean isEmpty() {
        return this.tree != null && this.items.isEmpty() && !this.isByReference();
    }

    public boolean isPresent() {
        return this.tree != null && !this.isByReference();
    }

    public boolean isByReference() {
        return this.tree != null && !((AttributeTree)this.tree).value().is(TerraformTree.Kind.TUPLE);
    }

    @Nullable
    protected HasTextRange toHighlight() {
        return this.tree != null ? ((AttributeTree)this.tree).key() : null;
    }
}

