/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.tree.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.api.tree.ForTupleTree;
import org.sonar.iac.terraform.api.tree.SyntaxToken;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.parser.TreeFactory;
import org.sonar.iac.terraform.tree.impl.AbstractForTree;

public class ForTupleTreeImpl
extends AbstractForTree
implements ForTupleTree {
    private final SyntaxToken openBracket;
    private final ExpressionTree expression;
    private final TreeFactory.Pair<SyntaxToken, ExpressionTree> condition;
    private final SyntaxToken closeBracket;

    public ForTupleTreeImpl(SyntaxToken openBracket, AbstractForTree.ForIntro intro, ExpressionTree expression, @Nullable TreeFactory.Pair<SyntaxToken, ExpressionTree> condition, SyntaxToken closeBracket) {
        super(intro);
        this.openBracket = openBracket;
        this.expression = expression;
        this.condition = condition;
        this.closeBracket = closeBracket;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public Optional<ExpressionTree> condition() {
        return this.condition != null ? Optional.of(this.condition.second()) : Optional.empty();
    }

    @Override
    public TerraformTree.Kind getKind() {
        return TerraformTree.Kind.FOR_TUPLE;
    }

    public List<Tree> children() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        children.add(this.openBracket);
        children.addAll(this.intro.children());
        children.add(this.expression);
        if (this.condition != null) {
            children.add(this.condition.first());
            children.add(this.condition.second());
        }
        children.add(this.closeBracket);
        return children;
    }
}

