/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.tree.impl;

import java.util.ArrayList;
import java.util.List;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.api.tree.SeparatedTrees;
import org.sonar.iac.terraform.api.tree.SyntaxToken;
import org.sonar.iac.terraform.api.tree.TemplateForDirectiveTree;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.api.tree.VariableExprTree;
import org.sonar.iac.terraform.tree.impl.TerraformTreeImpl;

public class TemplateForDirectiveTreeImpl
extends TerraformTreeImpl
implements TemplateForDirectiveTree {
    private final Intro intro;
    private final ExpressionTree expression;
    private final SyntaxToken endForOpenToken;
    private final SyntaxToken endForToken;
    private final SyntaxToken endForCloseToken;

    public TemplateForDirectiveTreeImpl(Intro intro, ExpressionTree expression, SyntaxToken endForOpenToken, SyntaxToken endForToken, SyntaxToken endForCloseToken) {
        this.intro = intro;
        this.expression = expression;
        this.endForOpenToken = endForOpenToken;
        this.endForToken = endForToken;
        this.endForCloseToken = endForCloseToken;
    }

    @Override
    public SeparatedTrees<VariableExprTree> loopVariables() {
        return this.intro.loopVariables;
    }

    @Override
    public ExpressionTree loopExpression() {
        return this.intro.loopExpression;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public TerraformTree.Kind getKind() {
        return TerraformTree.Kind.TEMPLATE_DIRECTIVE_FOR;
    }

    public List<Tree> children() {
        ArrayList<Tree> children = new ArrayList<Tree>(this.intro.children());
        children.add(this.expression);
        children.add(this.endForOpenToken);
        children.add(this.endForToken);
        children.add(this.endForCloseToken);
        return children;
    }

    public static class Intro
    extends TerraformTreeImpl {
        private final SyntaxToken forOpenToken;
        private final SyntaxToken forToken;
        private final SeparatedTrees<VariableExprTree> loopVariables;
        private final SyntaxToken inToken;
        private final ExpressionTree loopExpression;
        private final SyntaxToken forCloseToken;

        public Intro(SyntaxToken forOpenToken, SyntaxToken forToken, SeparatedTrees<VariableExprTree> loopVariables, SyntaxToken inToken, ExpressionTree loopExpression, SyntaxToken forCloseToken) {
            this.forOpenToken = forOpenToken;
            this.forToken = forToken;
            this.loopVariables = loopVariables;
            this.inToken = inToken;
            this.loopExpression = loopExpression;
            this.forCloseToken = forCloseToken;
        }

        @Override
        public TerraformTree.Kind getKind() {
            return null;
        }

        public List<Tree> children() {
            ArrayList<Tree> children = new ArrayList<Tree>();
            children.add(this.forOpenToken);
            children.add(this.forToken);
            children.addAll(this.loopVariables.treesAndSeparators());
            children.add(this.inToken);
            children.add(this.loopExpression);
            children.add(this.forCloseToken);
            return children;
        }
    }
}

