/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.externalreport;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rules.RuleType;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;
import org.sonarsource.analyzer.commons.xml.SafeStaxParserFactory;

public class PmdXmlReportReader {
    private static final Logger LOG = LoggerFactory.getLogger(PmdXmlReportReader.class);
    private static final Map<Integer, Severity> SEVERITIES = PmdXmlReportReader.severities();
    private final SensorContext context;
    private final File reportFile;
    private final ExternalRuleLoader ruleLoader;
    private InputFile inputFile = null;
    private NewExternalIssue issue = null;
    private NewIssueLocation issueLocation = null;
    private StringBuilder issueMessage = new StringBuilder();

    public PmdXmlReportReader(SensorContext context, File reportFile, ExternalRuleLoader ruleLoader) {
        this.context = context;
        this.reportFile = reportFile;
        this.ruleLoader = ruleLoader;
    }

    public static void read(SensorContext context, File reportFile, ExternalRuleLoader ruleLoader) throws XMLStreamException, IOException {
        new PmdXmlReportReader(context, reportFile, ruleLoader).parse();
    }

    private void parse() throws XMLStreamException, IOException {
        try (FileInputStream inputStream = new FileInputStream(this.reportFile);){
            XMLEventReader reader = SafeStaxParserFactory.createXMLInputFactory().createXMLEventReader(inputStream);
            while (reader.hasNext()) {
                this.onXmlEvent(reader.nextEvent());
            }
        }
    }

    private void onXmlEvent(XMLEvent event) {
        if (event.isStartElement()) {
            StartElement element = event.asStartElement();
            String elementName = element.getName().getLocalPart();
            if ("file".equals(elementName)) {
                String filePath = PmdXmlReportReader.getAttributeValue(element, "name");
                FilePredicates predicates = this.context.fileSystem().predicates();
                this.inputFile = this.context.fileSystem().inputFile(predicates.hasPath(filePath));
                if (this.inputFile == null) {
                    LOG.warn("No input file found for {}. No PMD issue will be imported on this file.", (Object)filePath);
                }
            } else if ("violation".equals(elementName) && this.inputFile != null) {
                this.onViolationStartElement(element);
            }
        } else if (event.isCharacters()) {
            this.issueMessage.append(event.asCharacters().getData());
        } else if (event.isEndElement() && "violation".equals(event.asEndElement().getName().getLocalPart()) && this.inputFile != null && this.issue != null) {
            this.issueLocation.message(this.issueMessage.toString());
            this.issue.at(this.issueLocation).save();
        }
    }

    private void onViolationStartElement(StartElement element) {
        try {
            TextRange textRange = this.textRange(element);
            String ruleId = PmdXmlReportReader.getAttributeValue(element, "rule");
            this.issue = this.context.newExternalIssue().engineId("pmd").ruleId(ruleId).type(RuleType.CODE_SMELL).severity(SEVERITIES.get(PmdXmlReportReader.getAttributeAsInt(element, "priority"))).remediationEffortMinutes(this.ruleLoader.ruleConstantDebtMinutes(ruleId));
            this.issueLocation = this.issue.newLocation().on((InputComponent)this.inputFile).at(textRange);
            this.issueMessage = new StringBuilder();
        }
        catch (RuntimeException e) {
            int lineNumber = element.getLocation().getLineNumber();
            LOG.warn("Can't import issue at line {} in {}: {}", new Object[]{lineNumber, this.reportFile, e.getMessage()});
            this.issue = null;
        }
    }

    private TextRange textRange(StartElement violationElement) {
        Integer beginLine = PmdXmlReportReader.getAttributeAsInt(violationElement, "beginline");
        try {
            Integer endLine = PmdXmlReportReader.getAttributeAsInt(violationElement, "endline");
            Integer beginColumn = PmdXmlReportReader.getAttributeAsInt(violationElement, "begincolumn");
            Integer endColumn = PmdXmlReportReader.getAttributeAsInt(violationElement, "endcolumn");
            return this.inputFile.newRange(beginLine.intValue(), beginColumn - 1, endLine.intValue(), endColumn.intValue());
        }
        catch (RuntimeException e) {
            return this.inputFile.selectLine(beginLine.intValue());
        }
    }

    private static String getAttributeValue(StartElement startElement, String attributeName) {
        Attribute attribute = startElement.getAttributeByName(new QName(attributeName));
        return attribute == null ? "" : attribute.getValue();
    }

    private static Integer getAttributeAsInt(StartElement startElement, String attributeName) {
        return Integer.parseInt(PmdXmlReportReader.getAttributeValue(startElement, attributeName));
    }

    private static Map<Integer, Severity> severities() {
        HashMap<Integer, Severity> map = new HashMap<Integer, Severity>();
        map.put(1, Severity.BLOCKER);
        map.put(2, Severity.CRITICAL);
        map.put(3, Severity.MAJOR);
        map.put(4, Severity.MINOR);
        map.put(5, Severity.INFO);
        return map;
    }
}

