/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.aws;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6263")
public class AwsLongTermAccessKeysCheck
extends AbstractMethodDetection {
    private static final String MESSAGE = "Make sure using a long-term access key is safe here.";

    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"com.amazonaws.auth.BasicAWSCredentials"}).constructor().withAnyParameters().build();
    }

    protected void onConstructorFound(NewClassTree newClassTree) {
        this.reportIssue((Tree)newClassTree.identifier(), MESSAGE);
    }
}

