/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.aws;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S6262")
public class AwsRegionSetterCheck
extends AbstractMethodDetection {
    private static final String STRING_TYPE = "java.lang.String";
    private static final String MESSAGE = "Give the enum value for this region instead.";
    private static final MethodMatchers REGION_SETTER_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"com.amazonaws.client.builder.AwsClientBuilder"}).names(new String[]{"withRegion", "setRegion"}).addParametersMatcher(new String[]{"java.lang.String"}).build();

    protected MethodMatchers getMethodInvocationMatchers() {
        return REGION_SETTER_MATCHER;
    }

    protected void onMethodInvocationFound(MethodInvocationTree tree) {
        ExpressionTree argument = (ExpressionTree)tree.arguments().get(0);
        if (argument.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            this.reportIssue((Tree)argument, MESSAGE);
        }
    }
}

