/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.List;
import org.sonar.plugins.java.api.semantic.MethodMatchers;

public class CredentialMethod {
    public final String cls;
    public final String name;
    public final List<String> args;
    public final List<Integer> indices;
    private MethodMatchers methodMatcher;

    public CredentialMethod(String cls, String name, List<String> args, List<Integer> indices) {
        this.cls = cls;
        this.name = name;
        this.args = args;
        this.indices = indices;
    }

    public boolean isConstructor() {
        int sep = Math.max(this.cls.lastIndexOf(46), this.cls.lastIndexOf(36));
        if (sep == -1) {
            return this.cls.equals(this.name);
        }
        return this.cls.substring(sep + 1).equals(this.name);
    }

    public MethodMatchers methodMatcher() {
        if (this.methodMatcher != null) {
            return this.methodMatcher;
        }
        MethodMatchers.NameBuilder nameBuilder = MethodMatchers.create().ofTypes(new String[]{this.cls});
        MethodMatchers.ParametersBuilder parametersBuilder = this.isConstructor() ? nameBuilder.constructor() : nameBuilder.names(new String[]{this.name});
        this.methodMatcher = parametersBuilder.addParametersMatcher(this.args.toArray(new String[0])).build();
        return this.methodMatcher;
    }
}

