/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.java.checks.helpers.CredentialMethod;

public class CredentialMethodsLoader {
    private CredentialMethodsLoader() {
    }

    public static Map<String, List<CredentialMethod>> load(String resourcePath) throws IOException {
        String rawData;
        try (InputStream in = CredentialMethodsLoader.class.getResourceAsStream(resourcePath);){
            if (in == null) {
                throw new IOException(String.format("Could not load methods from \"%s\".", resourcePath));
            }
            rawData = new String(in.readAllBytes(), StandardCharsets.UTF_8);
        }
        CredentialMethod[] credentialMethods = (CredentialMethod[])new Gson().fromJson(rawData, CredentialMethod[].class);
        return Arrays.stream(credentialMethods).collect(Collectors.groupingBy(m -> m.name));
    }
}

