/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.java.api.location.Position;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public final class ReassignmentFinder {
    private ReassignmentFinder() {
    }

    @CheckForNull
    public static ExpressionTree getClosestReassignmentOrDeclarationExpression(Tree startingPoint, Symbol referenceSymbol) {
        ExpressionTree initializerOrExpression;
        Tree result = referenceSymbol.declaration();
        List usages = referenceSymbol.usages();
        if (usages.size() != 1) {
            List<AssignmentExpressionTree> reassignments = ReassignmentFinder.getReassignments(referenceSymbol.owner().declaration(), usages);
            SyntaxToken startPointToken = startingPoint.firstToken();
            Tree lastReassignment = ReassignmentFinder.getClosestReassignment(startPointToken, reassignments);
            if (lastReassignment != null) {
                result = lastReassignment;
            }
        }
        if ((initializerOrExpression = ReassignmentFinder.getInitializerOrExpression(result)) == startingPoint) {
            return ReassignmentFinder.getClosestReassignmentOrDeclarationExpression(result, referenceSymbol);
        }
        return initializerOrExpression;
    }

    @CheckForNull
    public static ExpressionTree getInitializerOrExpression(@Nullable Tree tree) {
        if (tree == null) {
            return null;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            return ((VariableTree)tree).initializer();
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.ENUM_CONSTANT})) {
            return ((EnumConstantTree)tree).initializer();
        }
        if (tree instanceof AssignmentExpressionTree) {
            AssignmentExpressionTree assignmentExpressionTree = (AssignmentExpressionTree)tree;
            return assignmentExpressionTree.expression();
        }
        return null;
    }

    public static List<AssignmentExpressionTree> getReassignments(@Nullable Tree ownerDeclaration, List<IdentifierTree> usages) {
        if (ownerDeclaration != null) {
            ArrayList<AssignmentExpressionTree> assignments = new ArrayList<AssignmentExpressionTree>();
            for (IdentifierTree usage : usages) {
                ReassignmentFinder.checkAssignment(usage).ifPresent(assignments::add);
            }
            return assignments;
        }
        return new ArrayList<AssignmentExpressionTree>();
    }

    private static Optional<AssignmentExpressionTree> checkAssignment(IdentifierTree usage) {
        AssignmentExpressionTree assignment;
        IdentifierTree previousTree = usage;
        Tree nonParenthesisParent = previousTree.parent();
        while (nonParenthesisParent.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            previousTree = nonParenthesisParent;
            nonParenthesisParent = previousTree.parent();
        }
        if (nonParenthesisParent instanceof AssignmentExpressionTree && (assignment = (AssignmentExpressionTree)nonParenthesisParent).variable().equals((Object)previousTree)) {
            return Optional.of(assignment);
        }
        return Optional.empty();
    }

    @CheckForNull
    private static Tree getClosestReassignment(SyntaxToken startToken, List<AssignmentExpressionTree> reassignments) {
        return reassignments.stream().filter(a -> Position.startOf((Tree)a).isBefore(Position.startOf((SyntaxToken)startToken))).max(Comparator.comparing(Position::startOf)).orElse(null);
    }
}

