/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.helpers;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class TreeHelper {
    private TreeHelper() {
    }

    public static Set<MethodTree> findReachableMethodsInSameFile(Tree tree) {
        ReachableMethodsFinder finder = new ReachableMethodsFinder();
        tree.accept((TreeVisitor)finder);
        return finder.getReachableMethods();
    }

    public static Tree findClosestParentOfKind(Tree tree, Set<Tree.Kind> nodeKinds) {
        while (tree != null) {
            if (nodeKinds.contains(tree.kind())) {
                return tree;
            }
            tree = tree.parent();
        }
        return null;
    }

    private static class ReachableMethodsFinder
    extends BaseTreeVisitor {
        private final Map<MethodTree, Void> reachableMethods = new IdentityHashMap<MethodTree, Void>();

        private ReachableMethodsFinder() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            MethodTree declaration = tree.methodSymbol().declaration();
            if (declaration != null && declaration.is(new Tree.Kind[]{Tree.Kind.METHOD}) && !this.reachableMethods.containsKey(declaration)) {
                this.reachableMethods.put(declaration, null);
                declaration.accept((TreeVisitor)this);
            }
        }

        public Set<MethodTree> getReachableMethods() {
            return this.reachableMethods.keySet();
        }
    }
}

