/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.IterableAssert;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.internal.SensorContextTester;
import org.sonar.api.config.Settings;
import org.sonar.api.config.internal.MapSettings;
import org.sonar.api.internal.SonarRuntimeImpl;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.Rule;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.RspecKey;
import org.sonar.java.SonarComponents;

public abstract class CheckVerifier {
    private static final Logger LOG = Loggers.get(CheckVerifier.class);
    public static final String ISSUE_MARKER = "Noncompliant";
    public static final Map<String, IssueAttribute> ATTRIBUTE_MAP = ImmutableMap.builder().put((Object)"message", (Object)IssueAttribute.MESSAGE).put((Object)"effortToFix", (Object)IssueAttribute.EFFORT_TO_FIX).put((Object)"sc", (Object)IssueAttribute.START_COLUMN).put((Object)"startColumn", (Object)IssueAttribute.START_COLUMN).put((Object)"el", (Object)IssueAttribute.END_LINE).put((Object)"endLine", (Object)IssueAttribute.END_LINE).put((Object)"ec", (Object)IssueAttribute.END_COLUMN).put((Object)"endColumn", (Object)IssueAttribute.END_COLUMN).put((Object)"secondary", (Object)IssueAttribute.SECONDARY_LOCATIONS).build();
    private final ArrayListMultimap<Integer, Map<IssueAttribute, String>> expected = ArrayListMultimap.create();
    private boolean expectNoIssues = false;
    private String expectFileIssue;
    private String expectedProjectIssue;

    public void expectNoIssues() {
        this.expectNoIssues = true;
    }

    public void setExpectedFileIssue(String expectFileIssue) {
        this.expectFileIssue = expectFileIssue;
    }

    public void setExpectedProjectIssue(String expectedProjectIssue) {
        this.expectedProjectIssue = expectedProjectIssue;
    }

    public abstract String getExpectedIssueTrigger();

    protected void collectExpectedIssues(String comment, int line) {
        String expectedStart = this.getExpectedIssueTrigger();
        if (comment.startsWith(expectedStart)) {
            String cleanedComment = StringUtils.remove((String)comment, (String)expectedStart);
            EnumMap<IssueAttribute, String> attr = new EnumMap<IssueAttribute, String>(IssueAttribute.class);
            String expectedMessage = StringUtils.substringBetween((String)cleanedComment, (String)"{{", (String)"}}");
            if (StringUtils.isNotEmpty((String)expectedMessage)) {
                attr.put(IssueAttribute.MESSAGE, expectedMessage);
            }
            int expectedLine = line;
            String attributesSubstr = CheckVerifier.extractAttributes(comment, attr);
            if (StringUtils.startsWith((String)(cleanedComment = StringUtils.stripEnd((String)StringUtils.remove((String)StringUtils.remove((String)cleanedComment, (String)("[[" + attributesSubstr + "]]")), (String)("{{" + expectedMessage + "}}")), (String)" \t")), (String)"@")) {
                char firstChar = cleanedComment.charAt(1);
                int endIndex = cleanedComment.indexOf(32);
                int lineAdjustment = endIndex == -1 ? Integer.parseInt(cleanedComment.substring(2)) : Integer.parseInt(cleanedComment.substring(2, endIndex));
                if (firstChar == '+') {
                    expectedLine += lineAdjustment;
                } else if (firstChar == '-') {
                    expectedLine -= lineAdjustment;
                } else {
                    Fail.fail((String)"Use only '@+N' or '@-N' to shifts messages.");
                }
            }
            CheckVerifier.updateEndLine(expectedLine, attr);
            this.expected.put((Object)expectedLine, attr);
        }
    }

    private static String extractAttributes(String comment, Map<IssueAttribute, String> attr) {
        String attributesSubstr = StringUtils.substringBetween((String)comment, (String)"[[", (String)"]]");
        if (!StringUtils.isEmpty((String)attributesSubstr)) {
            Iterable attributes = Splitter.on((String)";").split((CharSequence)attributesSubstr);
            for (String attribute : attributes) {
                String[] split = StringUtils.split((String)attribute, (char)'=');
                if (split.length == 2 && ATTRIBUTE_MAP.containsKey(split[0])) {
                    attr.put(ATTRIBUTE_MAP.get(split[0]), split[1]);
                    continue;
                }
                Fail.fail((String)("// Noncompliant attributes not valid: " + attributesSubstr));
            }
        }
        return attributesSubstr;
    }

    private static void updateEndLine(int expectedLine, EnumMap<IssueAttribute, String> attr) {
        if (attr.containsKey((Object)IssueAttribute.END_LINE)) {
            String endLineStr = attr.get((Object)IssueAttribute.END_LINE);
            if (endLineStr.charAt(0) == '+') {
                int endLine = Integer.parseInt(endLineStr);
                attr.put(IssueAttribute.END_LINE, Integer.toString(expectedLine + endLine));
            } else {
                Fail.fail((String)"endLine attribute should be relative to the line and must be +N with N integer");
            }
        }
    }

    public ArrayListMultimap<Integer, Map<IssueAttribute, String>> getExpected() {
        return this.expected;
    }

    public void checkIssues(Set<AnalyzerMessage> issues, boolean bypassNoIssue) {
        if (this.expectNoIssues) {
            this.assertNoIssues(issues, bypassNoIssue);
        } else if (StringUtils.isNotEmpty((String)this.expectFileIssue)) {
            CheckVerifier.assertSingleIssue(issues, true, this.expectFileIssue);
        } else if (StringUtils.isNotEmpty((String)this.expectedProjectIssue)) {
            CheckVerifier.assertSingleIssue(issues, false, this.expectedProjectIssue);
        } else {
            this.assertMultipleIssue(issues);
        }
    }

    static SonarComponents sonarComponents(InputFile inputFile) {
        SensorContextTester context = SensorContextTester.create((File)new File("")).setRuntime(SonarRuntimeImpl.forSonarLint((Version)Version.create((int)6, (int)7)));
        context.setSettings((Settings)new MapSettings().setProperty("sonar.java.failOnException", Boolean.valueOf(true)));
        SonarComponents sonarComponents = new SonarComponents(null, (FileSystem)context.fileSystem(), null, null, null){

            public boolean reportAnalysisError(RecognitionException re, InputFile inputFile) {
                return false;
            }
        };
        sonarComponents.setSensorContext((SensorContext)context);
        context.fileSystem().add(inputFile);
        return sonarComponents;
    }

    private void assertMultipleIssue(Set<AnalyzerMessage> issues) throws AssertionError {
        Preconditions.checkState((!issues.isEmpty() ? 1 : 0) != 0, (Object)"At least one issue expected");
        LinkedList<Integer> unexpectedLines = new LinkedList<Integer>();
        RemediationFunction remediationFunction = CheckVerifier.remediationFunction(issues.iterator().next());
        for (AnalyzerMessage issue : issues) {
            CheckVerifier.validateIssue(this.expected, unexpectedLines, issue, remediationFunction);
        }
        if (!this.expected.isEmpty() || !unexpectedLines.isEmpty()) {
            Collections.sort(unexpectedLines);
            String expectedMsg = this.expectedMessage();
            String unexpectedMsg = this.unexpectedMessage(unexpectedLines);
            Fail.fail((String)(expectedMsg + unexpectedMsg));
        }
    }

    private String expectedMessage() {
        return !this.expected.isEmpty() ? "Expected " + this.expected : "";
    }

    private String unexpectedMessage(List<Integer> unexpectedLines) {
        if (unexpectedLines.isEmpty()) {
            return "";
        }
        return (this.expected.isEmpty() ? "" : ", ") + "Unexpected at " + unexpectedLines;
    }

    @CheckForNull
    private static RemediationFunction remediationFunction(AnalyzerMessage issue) {
        String ruleKey = CheckVerifier.ruleKey(issue);
        try {
            RuleJSON rule = CheckVerifier.getRuleJSON(ruleKey);
            if (rule.remediation == null) {
                return null;
            }
            switch (rule.remediation.func) {
                case "Linear": {
                    return RemediationFunction.LINEAR;
                }
                case "Constant/Issue": {
                    return RemediationFunction.CONST;
                }
            }
            return null;
        }
        catch (JsonParseException | IOException e) {
            LOG.debug("Remediation function and cost not provided, \"constant\" is assumed.");
            return null;
        }
    }

    private static RuleJSON getRuleJSON(String ruleKey) throws IOException {
        String ruleJson = "/org/sonar/l10n/java/rules/squid/" + ruleKey + "_java.json";
        URL resource = CheckVerifier.class.getResource(ruleJson);
        if (resource == null) {
            throw new IOException(ruleJson + " not found");
        }
        Gson gson = new Gson();
        return (RuleJSON)gson.fromJson((Reader)new InputStreamReader(resource.openStream(), "UTF-8"), RuleJSON.class);
    }

    private static String ruleKey(AnalyzerMessage issue) {
        String ruleKey;
        RspecKey rspecKeyAnnotation = (RspecKey)AnnotationUtils.getAnnotation(issue.getCheck().getClass(), RspecKey.class);
        if (rspecKeyAnnotation != null) {
            ruleKey = rspecKeyAnnotation.value();
        } else {
            Rule ruleAnnotation = (Rule)AnnotationUtils.getAnnotation(issue.getCheck().getClass(), Rule.class);
            if (ruleAnnotation != null) {
                ruleKey = ruleAnnotation.key();
            } else {
                Fail.fail((String)"Rules should be annotated with '@Rule(key = \"...\")' annotation (org.sonar.check.Rule).");
                return null;
            }
        }
        return ruleKey;
    }

    private static void validateIssue(Multimap<Integer, Map<IssueAttribute, String>> expected, List<Integer> unexpectedLines, AnalyzerMessage issue, @Nullable RemediationFunction remediationFunction) {
        int line = issue.getLine();
        if (expected.containsKey((Object)line)) {
            Map attrs = (Map)Iterables.getLast((Iterable)expected.get((Object)line));
            CheckVerifier.assertEquals(line, issue.getMessage(), attrs, IssueAttribute.MESSAGE);
            Double cost = issue.getCost();
            if (cost != null) {
                Preconditions.checkState((remediationFunction != RemediationFunction.CONST ? 1 : 0) != 0, (Object)"Rule with constant remediation function shall not provide cost");
                CheckVerifier.assertEquals(line, Integer.toString(cost.intValue()), attrs, IssueAttribute.EFFORT_TO_FIX);
            } else if (remediationFunction == RemediationFunction.LINEAR) {
                Fail.fail((String)"A cost should be provided for a rule with linear remediation function");
            }
            CheckVerifier.validateAnalyzerMessage(line, attrs, issue);
            expected.remove((Object)line, (Object)attrs);
        } else {
            unexpectedLines.add(line);
        }
    }

    private static void validateAnalyzerMessage(int line, Map<IssueAttribute, String> attrs, AnalyzerMessage analyzerMessage) {
        Double effortToFix = analyzerMessage.getCost();
        if (effortToFix != null) {
            CheckVerifier.assertEquals(line, Integer.toString(effortToFix.intValue()), attrs, IssueAttribute.EFFORT_TO_FIX);
        }
        AnalyzerMessage.TextSpan textSpan = analyzerMessage.primaryLocation();
        CheckVerifier.assertEquals(line, CheckVerifier.normalizeColumn(textSpan.startCharacter), attrs, IssueAttribute.START_COLUMN);
        CheckVerifier.assertEquals(line, Integer.toString(textSpan.endLine), attrs, IssueAttribute.END_LINE);
        CheckVerifier.assertEquals(line, CheckVerifier.normalizeColumn(textSpan.endCharacter), attrs, IssueAttribute.END_COLUMN);
        if (attrs.containsKey((Object)IssueAttribute.SECONDARY_LOCATIONS)) {
            List secondaryLocations = analyzerMessage.flows.stream().map(l -> (AnalyzerMessage)l.get(0)).collect(Collectors.toList());
            HashMultiset actualLines = HashMultiset.create();
            for (AnalyzerMessage secondaryLocation : secondaryLocations) {
                actualLines.add((Object)Integer.toString(secondaryLocation.getLine()));
            }
            ArrayList expected = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)attrs.get((Object)IssueAttribute.SECONDARY_LOCATIONS)));
            ArrayList<String> unexpected = new ArrayList<String>();
            for (String actualLine : actualLines) {
                if (expected.contains(actualLine)) {
                    expected.remove(actualLine);
                    continue;
                }
                unexpected.add(actualLine);
            }
            if (!expected.isEmpty() || !unexpected.isEmpty()) {
                Fail.fail((String)String.format("Secondary locations: expected: %s unexpected:%s. In %s:%d", expected, unexpected, CheckVerifier.normalizedFilePath(analyzerMessage), analyzerMessage.getLine()));
            }
        }
    }

    private static String normalizedFilePath(AnalyzerMessage analyzerMessage) {
        String absolutePath = analyzerMessage.getInputComponent().toString();
        return absolutePath.replace("\\", "/");
    }

    private static String normalizeColumn(int startCharacter) {
        return Integer.toString(startCharacter + 1);
    }

    private static void assertEquals(int line, String value, Map<IssueAttribute, String> attributes, IssueAttribute attribute) {
        if (attributes.containsKey((Object)attribute)) {
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)value).as("Line: " + line + " attribute mismatch for " + (Object)((Object)attribute) + ": " + attributes, new Object[0])).isEqualTo((Object)attributes.get((Object)attribute));
        }
    }

    private static void assertSingleIssue(Set<AnalyzerMessage> issues, boolean issueOnFile, String expectedMessage) {
        Preconditions.checkState((issues.size() == 1 ? 1 : 0) != 0, (Object)"A single issue is expected on the file");
        AnalyzerMessage issue = (AnalyzerMessage)Iterables.getFirst(issues, null);
        Assertions.assertThat((boolean)issue.getInputComponent().isFile()).isEqualTo(issueOnFile);
        Assertions.assertThat((Integer)issue.getLine()).isNull();
        Assertions.assertThat((String)issue.getMessage()).isEqualTo((Object)expectedMessage);
    }

    private void assertNoIssues(Set<AnalyzerMessage> issues, boolean bypass) {
        ((IterableAssert)Assertions.assertThat(issues).overridingErrorMessage("No issues expected but got: " + issues, new Object[0])).isEmpty();
        if (!bypass) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.expected.isEmpty()).overridingErrorMessage("The file should not declare noncompliants when no issues are expected", new Object[0])).isTrue();
        }
    }

    static class RuleJSON {
        Remediation remediation;

        RuleJSON() {
        }

        static class Remediation {
            String func;

            Remediation() {
            }
        }
    }

    static enum RemediationFunction {
        LINEAR,
        CONST;

    }

    public static enum IssueAttribute {
        MESSAGE,
        START_COLUMN,
        END_COLUMN,
        END_LINE,
        EFFORT_TO_FIX,
        SECONDARY_LOCATIONS;

    }
}

