/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier;

import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Fail;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.JavaAstScanner;
import org.sonar.java.ast.visitors.SubscriptionVisitor;
import org.sonar.java.checks.verifier.CheckVerifier;
import org.sonar.java.model.JavaVersionImpl;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.java.model.VisitorsBridgeForTests;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;

@Beta
public class JavaCheckVerifier
extends CheckVerifier {
    static final String DEFAULT_TEST_JARS_DIRECTORY = "target/test-jars";
    private String testJarsDirectory = "target/test-jars";
    private boolean providedJavaVersion = false;
    private JavaVersion javaVersion = new JavaVersionImpl();

    private JavaCheckVerifier() {
    }

    @Override
    public String getExpectedIssueTrigger() {
        return "// Noncompliant";
    }

    public static void verify(String filename, JavaFileScanner check) {
        JavaCheckVerifier.scanFile(filename, check, new JavaCheckVerifier());
    }

    public static void verify(String filename, JavaFileScanner check, int javaVersion) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier();
        javaCheckVerifier.providedJavaVersion = true;
        javaCheckVerifier.javaVersion = new JavaVersionImpl(javaVersion);
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier);
    }

    public static void verify(String filename, JavaFileScanner check, Collection<File> classpath) {
        JavaCheckVerifier.scanFile(filename, check, new JavaCheckVerifier(), classpath);
    }

    public static void verify(String filename, JavaFileScanner check, String testJarsDirectory) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier();
        javaCheckVerifier.testJarsDirectory = testJarsDirectory;
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier);
    }

    public static void verifyNoIssue(String filename, JavaFileScanner check) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier();
        javaCheckVerifier.expectNoIssues();
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier);
    }

    public static void verifyNoIssueWithoutSemantic(String filename, JavaFileScanner check, int javaVersion) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier(){

            @Override
            public String getExpectedIssueTrigger() {
                return "// NOSEMANTIC_ISSUE";
            }
        };
        javaCheckVerifier.expectNoIssues();
        javaCheckVerifier.providedJavaVersion = true;
        javaCheckVerifier.javaVersion = new JavaVersionImpl(javaVersion);
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier, Collections.emptyList(), false);
    }

    public static void verifyNoIssueWithoutSemantic(String filename, JavaFileScanner check) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier(){

            @Override
            public String getExpectedIssueTrigger() {
                return "// NOSEMANTIC_ISSUE";
            }
        };
        javaCheckVerifier.expectNoIssues();
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier, Collections.emptyList(), false);
    }

    public static void verifyNoIssue(String filename, JavaFileScanner check, int javaVersion) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier();
        javaCheckVerifier.expectNoIssues();
        javaCheckVerifier.providedJavaVersion = true;
        javaCheckVerifier.javaVersion = new JavaVersionImpl(javaVersion);
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier);
    }

    public static void verifyIssueOnFile(String filename, String message, JavaFileScanner check) {
        JavaCheckVerifier javaCheckVerifier = new JavaCheckVerifier();
        javaCheckVerifier.setExpectedFileIssue(message);
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier);
    }

    private static void scanFile(String filename, JavaFileScanner check, JavaCheckVerifier javaCheckVerifier) {
        List<File> classpath = JavaCheckVerifier.getClassPath(javaCheckVerifier.testJarsDirectory);
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier, classpath);
    }

    static List<File> getClassPath(String jarsDirectory) {
        List<Object> classpath = Lists.newLinkedList();
        Path testJars = Paths.get(jarsDirectory, new String[0]);
        if (testJars.toFile().exists()) {
            classpath = JavaCheckVerifier.getFilesRecursively(testJars, new String[]{"jar", "zip"});
        } else if (!DEFAULT_TEST_JARS_DIRECTORY.equals(jarsDirectory)) {
            Fail.fail((String)("The directory to be used to extend class path does not exists (" + testJars.toAbsolutePath() + ")."));
        }
        classpath.add(new File("target/test-classes"));
        return classpath;
    }

    static List<File> getFilesRecursively(Path root, final String[] extensions) {
        final ArrayList<File> files = new ArrayList<File>();
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) {
                for (String extension : extensions) {
                    if (!filePath.toString().endsWith("." + extension)) continue;
                    files.add(filePath.toFile());
                    break;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)visitor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return files;
    }

    private static void scanFile(String filename, JavaFileScanner check, JavaCheckVerifier javaCheckVerifier, Collection<File> classpath) {
        JavaCheckVerifier.scanFile(filename, check, javaCheckVerifier, classpath, true);
    }

    private static void scanFile(String filename, JavaFileScanner check, JavaCheckVerifier javaCheckVerifier, Collection<File> classpath, boolean withSemantic) {
        ExpectedIssueCollector expectedIssueCollector = new ExpectedIssueCollector(javaCheckVerifier);
        File file = new File(filename);
        SonarComponents sonarComponents = CheckVerifier.sonarComponents(file);
        VisitorsBridgeForTests visitorsBridge = withSemantic ? new VisitorsBridgeForTests((Iterable)Lists.newArrayList((Object[])new JavaFileScanner[]{check, expectedIssueCollector}), (List)Lists.newArrayList(classpath), sonarComponents) : new VisitorsBridgeForTests((Iterable)Lists.newArrayList((Object[])new JavaFileScanner[]{check, expectedIssueCollector}), sonarComponents);
        JavaAstScanner.scanSingleFileForTests((File)file, (VisitorsBridge)visitorsBridge, (JavaVersion)javaCheckVerifier.javaVersion);
        VisitorsBridgeForTests.TestJavaFileScannerContext testJavaFileScannerContext = visitorsBridge.lastCreatedTestContext();
        if (testJavaFileScannerContext == null) {
            Fail.fail((String)"Semantic was required but it was not possible to create it. Please checks the logs to find out the reason.");
        }
        javaCheckVerifier.checkIssues(testJavaFileScannerContext.getIssues(), javaCheckVerifier.providedJavaVersion);
    }

    static class ExpectedIssueCollector
    extends SubscriptionVisitor {
        private final CheckVerifier verifier;

        public ExpectedIssueCollector(CheckVerifier verifier) {
            this.verifier = verifier;
        }

        public List<Tree.Kind> nodesToVisit() {
            return Collections.singletonList(Tree.Kind.TRIVIA);
        }

        public void visitTrivia(SyntaxTrivia syntaxTrivia) {
            this.verifier.collectExpectedIssues(syntaxTrivia.comment(), syntaxTrivia.startLine());
        }
    }
}

