/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier;

import com.google.common.annotations.Beta;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.ast.JavaAstScanner;
import org.sonar.java.ast.parser.JavaParser;
import org.sonar.java.checks.verifier.CheckVerifier;
import org.sonar.java.checks.verifier.JavaCheckVerifier;
import org.sonar.java.model.JavaVersionImpl;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.java.model.VisitorsBridgeForTests;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaVersion;

@Beta
public class MultipleFilesJavaCheckVerifier
extends CheckVerifier {
    public static void verify(List<String> filesToScan, JavaFileScanner check) {
        MultipleFilesJavaCheckVerifier.verify(new MultipleFilesJavaCheckVerifier(), filesToScan, check, false, true);
    }

    public static void verifyNoIssue(List<String> filesToScan, JavaFileScanner check) {
        MultipleFilesJavaCheckVerifier.verify(new MultipleFilesJavaCheckVerifier(), filesToScan, check, true, true);
    }

    public static void verifyNoIssueWithoutSemantic(List<String> filesToScan, JavaFileScanner check) {
        MultipleFilesJavaCheckVerifier verifier = new MultipleFilesJavaCheckVerifier(){

            @Override
            public String getExpectedIssueTrigger() {
                return "// NOSEMANTIC_ISSUE";
            }
        };
        MultipleFilesJavaCheckVerifier.verify(verifier, filesToScan, check, true, false);
    }

    private static void verify(MultipleFilesJavaCheckVerifier verifier, List<String> filesToScan, JavaFileScanner check, boolean expectNoIssues, boolean withSemantic) {
        if (expectNoIssues) {
            verifier.expectNoIssues();
        }
        Set<AnalyzerMessage> issues = verifier.scanFiles(filesToScan, check, withSemantic);
        verifier.checkIssues(issues, expectNoIssues);
    }

    private Set<AnalyzerMessage> scanFiles(List<String> filesToScan, JavaFileScanner check, boolean withSemantic) {
        List<File> classPath = JavaCheckVerifier.getClassPath("target/test-jars");
        VisitorsBridgeForTests visitorsBridge = withSemantic ? new VisitorsBridgeForTests(Arrays.asList(new JavaFileScanner[]{check, new JavaCheckVerifier.ExpectedIssueCollector(this)}), classPath, null) : new VisitorsBridgeForTests(Arrays.asList(new JavaFileScanner[]{check, new JavaCheckVerifier.ExpectedIssueCollector(this)}), null);
        visitorsBridge.setJavaVersion((JavaVersion)new JavaVersionImpl());
        JavaAstScanner astScanner = new JavaAstScanner(JavaParser.createParser(), null);
        astScanner.setVisitorBridge((VisitorsBridge)visitorsBridge);
        astScanner.scan((Collection)filesToScan.stream().map(File::new).collect(Collectors.toList()));
        VisitorsBridgeForTests.TestJavaFileScannerContext testJavaFileScannerContext = visitorsBridge.lastCreatedTestContext();
        return testJavaFileScannerContext.getIssues();
    }

    @Override
    public String getExpectedIssueTrigger() {
        return "// Noncompliant";
    }
}

