/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier;

import com.google.common.annotations.Beta;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Fail;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.checks.verifier.CheckVerifier;
import org.sonar.java.checks.verifier.XmlCheckVerifier;
import org.sonar.java.xml.XmlParser;
import org.sonar.java.xml.maven.PomCheck;
import org.sonar.java.xml.maven.PomCheckContext;
import org.sonar.java.xml.maven.PomParser;
import org.sonar.maven.model.LocatedTree;
import org.sonar.maven.model.maven2.MavenProject;
import org.sonar.plugins.java.api.JavaCheck;
import org.w3c.dom.Document;

@Beta
public class PomCheckVerifier
extends CheckVerifier {
    private PomCheckVerifier() {
    }

    @Override
    public String getExpectedIssueTrigger() {
        return "Noncompliant";
    }

    public static void verify(String filename, PomCheck check) {
        PomCheckVerifier mavenCheckVerifier = new PomCheckVerifier();
        PomCheckVerifier.scanFile(filename, check, mavenCheckVerifier);
    }

    public static void verifyNoIssue(String filename, PomCheck check) {
        PomCheckVerifier mavenCheckVerifier = new PomCheckVerifier();
        mavenCheckVerifier.expectNoIssues();
        PomCheckVerifier.scanFile(filename, check, mavenCheckVerifier);
    }

    public static void verifyIssueOnFile(String filename, String message, PomCheck check) {
        PomCheckVerifier mavenCheckVerifier = new PomCheckVerifier();
        mavenCheckVerifier.setExpectedFileIssue(message);
        PomCheckVerifier.scanFile(filename, check, mavenCheckVerifier);
    }

    private static void scanFile(String filename, PomCheck check, PomCheckVerifier mavenCheckVerifier) {
        File pom = new File(filename);
        Document document = XmlParser.parseXML((File)pom);
        if (document != null) {
            MavenProject project = PomParser.parseXML((File)pom);
            if (project != null) {
                XmlCheckVerifier.retrieveExpectedIssuesFromFile(pom, mavenCheckVerifier);
                FakePomCheckContext context = new FakePomCheckContext(document, pom, project);
                check.scanFile((PomCheckContext)context);
                mavenCheckVerifier.checkIssues(context.getMessages(), false);
            } else {
                Fail.fail((String)"The test file is not a pom");
            }
        } else {
            Fail.fail((String)"The test file can not be parsed");
        }
    }

    private static class FakePomCheckContext
    extends XmlCheckVerifier.FakeXmlCheckContext
    implements PomCheckContext {
        private final MavenProject project;

        public FakePomCheckContext(Document document, File pom, MavenProject project) {
            super(document, pom);
            this.project = project;
        }

        public MavenProject getMavenProject() {
            return this.project;
        }

        public void reportIssue(PomCheck check, LocatedTree tree, String message) {
            this.reportIssue((JavaCheck)check, tree.startLocation().line(), message);
        }

        public void reportIssue(PomCheck check, int line, String message, List<PomCheckContext.Location> secondary) {
            AnalyzerMessage analyzerMessage = new AnalyzerMessage((JavaCheck)check, this.getFile(), line, message, 0);
            for (PomCheckContext.Location location : secondary) {
                AnalyzerMessage secondaryLocation = new AnalyzerMessage((JavaCheck)check, this.getFile(), location.startLine(), location.msg, 0);
                analyzerMessage.flows.add(Collections.singletonList(secondaryLocation));
            }
            this.getMessages().add(analyzerMessage);
        }
    }
}

