/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier;

import com.google.common.annotations.Beta;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.xpath.XPathFactory;
import org.assertj.core.api.Fail;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.checks.verifier.CheckVerifier;
import org.sonar.java.xml.XmlCheck;
import org.sonar.java.xml.XmlCheckContext;
import org.sonar.java.xml.XmlCheckContextImpl;
import org.sonar.java.xml.XmlCheckUtils;
import org.sonar.java.xml.XmlParser;
import org.sonar.plugins.java.api.JavaCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Beta
public class XmlCheckVerifier
extends CheckVerifier {
    private XmlCheckVerifier() {
    }

    @Override
    public String getExpectedIssueTrigger() {
        return "Noncompliant";
    }

    public static void verify(String filename, XmlCheck check) {
        XmlCheckVerifier xmlCheckVerifier = new XmlCheckVerifier();
        XmlCheckVerifier.scanFile(filename, check, xmlCheckVerifier);
    }

    public static void verifyNoIssue(String filename, XmlCheck check) {
        XmlCheckVerifier xmlCheckVerifier = new XmlCheckVerifier();
        xmlCheckVerifier.expectNoIssues();
        XmlCheckVerifier.scanFile(filename, check, xmlCheckVerifier);
    }

    public static void verifyIssueOnFile(String filename, String message, XmlCheck check) {
        XmlCheckVerifier xmlCheckVerifier = new XmlCheckVerifier();
        xmlCheckVerifier.setExpectedFileIssue(message);
        XmlCheckVerifier.scanFile(filename, check, xmlCheckVerifier);
    }

    private static void scanFile(String filename, XmlCheck check, XmlCheckVerifier xmlCheckVerifier) {
        File file = new File(filename);
        Document document = XmlParser.parseXML((File)file);
        if (document != null) {
            XmlCheckVerifier.retrieveExpectedIssuesFromFile(file, xmlCheckVerifier);
            FakeXmlCheckContext context = new FakeXmlCheckContext(document, file);
            check.scanFile((XmlCheckContext)context);
            xmlCheckVerifier.checkIssues(context.messages, false);
        } else {
            Fail.fail((String)"The test file can not be parsed");
        }
    }

    protected static void retrieveExpectedIssuesFromFile(File xmlFile, CheckVerifier checkVerifier) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        try (FileInputStream is = new FileInputStream(xmlFile);){
            XMLStreamReader reader = factory.createXMLStreamReader(is);
            while (reader.hasNext()) {
                int line = reader.getLocation().getLineNumber();
                reader.next();
                if (reader.getEventType() != 5) continue;
                String text = reader.getText().trim();
                checkVerifier.collectExpectedIssues(text, line);
            }
        }
        catch (IOException | XMLStreamException e) {
            Fail.fail((String)"The test file can not be parsed to retrieve comments", (Throwable)e);
        }
    }

    public static class FakeXmlCheckContext
    extends XmlCheckContextImpl {
        private final Set<AnalyzerMessage> messages = new HashSet<AnalyzerMessage>();

        public FakeXmlCheckContext(Document document, File file) {
            super(document, file, XPathFactory.newInstance().newXPath(), CheckVerifier.sonarComponents(file));
        }

        public Set<AnalyzerMessage> getMessages() {
            return this.messages;
        }

        public void reportIssueOnFile(JavaCheck check, String message) {
            this.reportIssue(check, -1, message);
        }

        public void reportIssue(JavaCheck check, Node node, String message) {
            this.reportIssue(check, node, message, new HashSet<XmlCheckContext.XmlDocumentLocation>(), null);
        }

        public void reportIssue(JavaCheck check, int line, String message) {
            this.messages.add(new AnalyzerMessage(check, this.getFile(), line, message, 0));
        }

        public void reportIssue(JavaCheck check, Node node, String message, Iterable<XmlCheckContext.XmlDocumentLocation> secondary) {
            this.reportIssue(check, node, message, secondary, null);
        }

        public void reportIssue(JavaCheck check, Node node, String message, Iterable<XmlCheckContext.XmlDocumentLocation> secondary, @Nullable Integer cost) {
            Integer line = XmlCheckUtils.nodeLine((Node)node);
            if (line != null) {
                this.messages.add(this.buildAnalyzerMessage(check, message, line, secondary, cost, this.getFile()));
            } else {
                Fail.fail((String)"The provided node does not have line attribute 'start_column'");
            }
        }
    }
}

