/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.sonar.java.annotations.VisibleForTesting;

public final class FilesUtils {
    public static final String DEFAULT_TEST_JARS_DIRECTORY = "../java-checks-test-sources/target/test-jars";

    private FilesUtils() {
    }

    public static List<File> getClassPath(String jarsDirectory) {
        List<File> classpath = new LinkedList<File>();
        Path testJars = Paths.get(jarsDirectory, new String[0]);
        if (testJars.toFile().exists()) {
            classpath = FilesUtils.getFilesRecursively(testJars, "jar", "zip");
        } else if (!DEFAULT_TEST_JARS_DIRECTORY.equals(jarsDirectory)) {
            throw new AssertionError((Object)("The directory to be used to extend class path does not exists (" + testJars.toAbsolutePath() + ")."));
        }
        classpath.add(new File("target/test-classes"));
        return classpath;
    }

    @VisibleForTesting
    public static List<File> getFilesRecursively(Path root, final String ... extensions) {
        final ArrayList<File> files = new ArrayList<File>();
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) {
                for (String extension : extensions) {
                    if (!filePath.toString().endsWith("." + extension)) continue;
                    files.add(filePath.toFile());
                    break;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)visitor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return files;
    }
}

