/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier;

import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.internal.SensorContextTester;
import org.sonar.api.config.internal.MapSettings;
import org.sonar.api.internal.SonarRuntimeImpl;
import org.sonar.api.utils.Version;
import org.sonar.java.AnalyzerMessage;
import org.sonar.java.SonarComponents;
import org.sonar.java.annotations.Beta;
import org.sonar.java.ast.JavaAstScanner;
import org.sonar.java.checks.verifier.CheckVerifier;
import org.sonar.java.checks.verifier.Expectations;
import org.sonar.java.checks.verifier.FilesUtils;
import org.sonar.java.classpath.ClasspathForMain;
import org.sonar.java.classpath.ClasspathForTest;
import org.sonar.java.model.JavaVersionImpl;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.java.model.VisitorsBridgeForTests;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaVersion;

public class InternalCheckVerifier
implements CheckVerifier {
    private static final String CHECK_OR_CHECKS = "check(s)";
    private static final String FILE_OR_FILES = "file(s)";
    private static final JavaVersion DEFAULT_JAVA_VERSION = new JavaVersionImpl();
    private static final List<File> DEFAULT_CLASSPATH = FilesUtils.getClassPath("../java-checks-test-sources/target/test-jars");
    private boolean withoutSemantic = false;
    private List<JavaFileScanner> checks = null;
    private List<InputFile> files = null;
    private JavaVersion javaVersion = null;
    private List<File> classpath = null;
    private Consumer<Set<AnalyzerMessage>> customIssueVerifier = null;
    private Expectations expectations = new Expectations();

    private InternalCheckVerifier() {
    }

    public static InternalCheckVerifier newInstance() {
        return new InternalCheckVerifier();
    }

    @Override
    public InternalCheckVerifier withCheck(JavaFileScanner check) {
        InternalCheckVerifier.requiresNull(this.checks, CHECK_OR_CHECKS);
        this.checks = Collections.singletonList(check);
        return this;
    }

    @Override
    public InternalCheckVerifier withChecks(JavaFileScanner ... checks) {
        InternalCheckVerifier.requiresNull(this.checks, CHECK_OR_CHECKS);
        InternalCheckVerifier.requiresNonEmpty(Arrays.asList(checks), "check");
        this.checks = Arrays.asList(checks);
        return this;
    }

    @Override
    public InternalCheckVerifier withClassPath(Collection<File> classpath) {
        InternalCheckVerifier.requiresNull(this.classpath, "classpath");
        this.classpath = new ArrayList<File>(classpath);
        return this;
    }

    @Beta
    public InternalCheckVerifier withCustomIssueVerifier(Consumer<Set<AnalyzerMessage>> customIssueVerifier) {
        InternalCheckVerifier.requiresNull(this.customIssueVerifier, "custom issue verifier");
        this.customIssueVerifier = customIssueVerifier;
        return this;
    }

    @Override
    public InternalCheckVerifier withJavaVersion(int javaVersionAsInt) {
        InternalCheckVerifier.requiresNull(this.javaVersion, "java version");
        this.javaVersion = new JavaVersionImpl(javaVersionAsInt);
        return this;
    }

    @Override
    public InternalCheckVerifier onFile(String filename) {
        InternalCheckVerifier.requiresNull(this.files, FILE_OR_FILES);
        return this.onFiles(Collections.singletonList(filename));
    }

    @Override
    public InternalCheckVerifier onFiles(String ... filenames) {
        List<String> asList = Arrays.asList(filenames);
        InternalCheckVerifier.requiresNonEmpty(asList, "file");
        return this.onFiles(Arrays.asList(filenames));
    }

    @Override
    public InternalCheckVerifier onFiles(Collection<String> filenames) {
        InternalCheckVerifier.requiresNull(this.files, FILE_OR_FILES);
        InternalCheckVerifier.requiresNonEmpty(filenames, "file");
        this.files = filenames.stream().map(File::new).map(InternalCheckVerifier::inputFile).collect(Collectors.toList());
        return this;
    }

    @Override
    public InternalCheckVerifier withoutSemantic() {
        this.withoutSemantic = true;
        return this;
    }

    @Override
    public void verifyIssues() {
        InternalCheckVerifier.requiresNonNull(this.checks, CHECK_OR_CHECKS);
        InternalCheckVerifier.requiresNonNull(this.files, FILE_OR_FILES);
        this.verifyAll();
    }

    @Override
    public void verifyIssueOnFile(String expectedIssueMessage) {
        InternalCheckVerifier.requiresNonNull(this.checks, CHECK_OR_CHECKS);
        InternalCheckVerifier.requiresNonNull(this.files, FILE_OR_FILES);
        this.expectations.setExpectedFileIssue(expectedIssueMessage);
        this.verifyAll();
    }

    @Override
    public void verifyIssueOnProject(String expectedIssueMessage) {
        InternalCheckVerifier.requiresNonNull(this.checks, CHECK_OR_CHECKS);
        InternalCheckVerifier.requiresNonNull(this.files, FILE_OR_FILES);
        this.expectations.setExpectedProjectIssue(expectedIssueMessage);
        this.verifyAll();
    }

    @Override
    public void verifyNoIssues() {
        InternalCheckVerifier.requiresNonNull(this.checks, CHECK_OR_CHECKS);
        InternalCheckVerifier.requiresNonNull(this.files, FILE_OR_FILES);
        this.expectations.setExpectNoIssues();
        this.verifyAll();
    }

    private void verifyAll() {
        VisitorsBridgeForTests visitorsBridge;
        ArrayList<JavaFileScanner> visitors = new ArrayList<JavaFileScanner>(this.checks);
        if (this.withoutSemantic && this.expectations.expectNoIssues()) {
            visitors.add((JavaFileScanner)this.expectations.noEffectParser());
        } else {
            visitors.add((JavaFileScanner)this.expectations.parser());
        }
        SonarComponents sonarComponents = InternalCheckVerifier.sonarComponents();
        if (this.withoutSemantic) {
            visitorsBridge = new VisitorsBridgeForTests(visitors, sonarComponents);
        } else {
            List<File> actualClasspath = this.classpath == null ? DEFAULT_CLASSPATH : this.classpath;
            visitorsBridge = new VisitorsBridgeForTests(visitors, actualClasspath, sonarComponents);
        }
        JavaAstScanner astScanner = new JavaAstScanner(sonarComponents);
        visitorsBridge.setJavaVersion(this.javaVersion == null ? DEFAULT_JAVA_VERSION : this.javaVersion);
        astScanner.setVisitorBridge((VisitorsBridge)visitorsBridge);
        astScanner.scan(this.files);
        VisitorsBridgeForTests.TestJavaFileScannerContext testJavaFileScannerContext = visitorsBridge.lastCreatedTestContext();
        this.checkIssues(testJavaFileScannerContext.getIssues());
    }

    private void checkIssues(Set<AnalyzerMessage> issues) {
        if (this.expectations.expectNoIssues()) {
            InternalCheckVerifier.assertNoIssues(issues);
        } else if (this.expectations.expectIssueAtFileLevel() || this.expectations.expectIssueAtProjectLevel()) {
            this.assertComponentIssue(issues);
        } else {
            this.assertMultipleIssues(issues);
        }
        if (this.customIssueVerifier != null) {
            this.customIssueVerifier.accept(issues);
        }
    }

    private static void assertNoIssues(Set<AnalyzerMessage> issues) {
        if (issues.isEmpty()) {
            return;
        }
        String issuesAsString = issues.stream().sorted(InternalCheckVerifier.issueLineSorter()).map(issue -> String.format("'%s' in %s%s", issue.getMessage(), issue.getInputComponent(), issue.getLine() == null ? "" : ":" + issue.getLine())).collect(Collectors.joining("\n--> ", "\n--> ", ""));
        throw new AssertionError((Object)String.format("No issues expected but got %d issue(s):%s", issues.size(), issuesAsString));
    }

    private static Comparator<? super AnalyzerMessage> issueLineSorter() {
        return (i1, i2) -> {
            if (i1.getLine() == null) {
                return 1;
            }
            if (i2.getLine() == null) {
                return -1;
            }
            return Integer.compare(i1.getLine(), i2.getLine());
        };
    }

    private void assertComponentIssue(Set<AnalyzerMessage> issues) {
        String expectedMessage = this.expectations.expectedFileIssue();
        String component = "file";
        String otherComponent = "project";
        if (this.expectations.expectIssueAtProjectLevel()) {
            expectedMessage = this.expectations.expectedProjectIssue();
            component = "project";
            otherComponent = "file";
        }
        if (issues.size() != 1) {
            String issueNumberMessage = issues.isEmpty() ? "none has been raised" : String.format("%d issues have been raised", issues.size());
            throw new AssertionError((Object)String.format("A single issue is expected on the %s, but %s", component, issueNumberMessage));
        }
        AnalyzerMessage issue = issues.iterator().next();
        if (issue.getLine() != null) {
            throw new AssertionError((Object)String.format("Expected an issue directly on %s but was raised on line %d", component, issue.getLine()));
        }
        if (this.expectations.expectIssueAtProjectLevel() && issue.getInputComponent().isFile() || this.expectations.expectIssueAtFileLevel() && !issue.getInputComponent().isFile()) {
            throw new AssertionError((Object)String.format("Expected the issue to be raised at %s level, not at %s level", component, otherComponent));
        }
        if (!expectedMessage.equals(issue.getMessage())) {
            throw new AssertionError((Object)String.format("Expected the issue message to be:%n\t\"%s\"%nbut was:%n\t\"%s\"", expectedMessage, issue.getMessage()));
        }
    }

    private void assertMultipleIssues(Set<AnalyzerMessage> issues) throws AssertionError {
        if (issues.isEmpty()) {
            throw new AssertionError((Object)"No issue raised. At least one issue expected");
        }
        LinkedList<Integer> unexpectedLines = new LinkedList<Integer>();
        Expectations.RemediationFunction remediationFunction = Expectations.remediationFunction(issues.iterator().next());
        Map<Integer, List<Expectations.Issue>> expected = this.expectations.issues;
        for (AnalyzerMessage issue : issues) {
            this.validateIssue(expected, unexpectedLines, issue, remediationFunction);
        }
        if (!expected.isEmpty() || !unexpectedLines.isEmpty()) {
            Collections.sort(unexpectedLines);
            List expectedLines = expected.keySet().stream().sorted().collect(Collectors.toList());
            throw new AssertionError((Object)((expectedLines.isEmpty() ? "" : String.format("Expected at %s", expectedLines)) + (expectedLines.isEmpty() || unexpectedLines.isEmpty() ? "" : ", ") + (unexpectedLines.isEmpty() ? "" : String.format("Unexpected at %s", unexpectedLines))));
        }
        this.assertSuperfluousFlows();
    }

    private void validateIssue(Map<Integer, List<Expectations.Issue>> expected, List<Integer> unexpectedLines, AnalyzerMessage issue, @Nullable Expectations.RemediationFunction remediationFunction) {
        int line = issue.getLine();
        if (expected.containsKey(line)) {
            Expectations.Issue attrs = expected.get(line).get(0);
            InternalCheckVerifier.validateRemediationFunction(attrs, issue, remediationFunction);
            this.validateAnalyzerMessageAttributes(attrs, issue);
            expected.computeIfPresent(line, (l, issues) -> {
                issues.remove(attrs);
                return issues.isEmpty() ? null : issues;
            });
        } else {
            unexpectedLines.add(line);
        }
    }

    private static void validateRemediationFunction(Expectations.Issue attributes, AnalyzerMessage issue, @Nullable Expectations.RemediationFunction remediationFunction) {
        if (remediationFunction == null) {
            return;
        }
        Double effortToFix = issue.getCost();
        if (effortToFix != null) {
            if (remediationFunction == Expectations.RemediationFunction.CONST) {
                throw new AssertionError((Object)"Rule with constant remediation function shall not provide cost");
            }
            InternalCheckVerifier.assertAttributeMatch(issue, effortToFix, attributes, Expectations.IssueAttribute.EFFORT_TO_FIX);
        } else if (remediationFunction == Expectations.RemediationFunction.LINEAR) {
            throw new AssertionError((Object)"A cost should be provided for a rule with linear remediation function");
        }
    }

    private void assertSuperfluousFlows() {
        Set<String> unseenFlowIds = this.expectations.unseenFlowIds();
        Map unseenFlowWithLines = unseenFlowIds.stream().collect(Collectors.toMap(Function.identity(), this.expectations::flowToLines));
        if (!unseenFlowWithLines.isEmpty()) {
            throw new AssertionError((Object)String.format("Following flow comments were observed, but not referenced by any issue: %s", unseenFlowWithLines));
        }
    }

    private static void assertAttributeMatch(AnalyzerMessage issue, Object value, Map<Expectations.IssueAttribute, Object> attributes, Expectations.IssueAttribute attribute) {
        if (attributes.containsKey((Object)attribute) && !value.equals(attribute.get(attributes))) {
            throw new AssertionError((Object)String.format("line %d attribute mismatch for '%s'. Expected: '%s', but was: '%s'", new Object[]{issue.getLine(), attribute, attribute.get(attributes), value}));
        }
    }

    private void validateAnalyzerMessageAttributes(Expectations.Issue attrs, AnalyzerMessage analyzerMessage) {
        InternalCheckVerifier.assertAttributeMatch(analyzerMessage, analyzerMessage.getMessage(), attrs, Expectations.IssueAttribute.MESSAGE);
        InternalCheckVerifier.validateLocation(analyzerMessage, attrs);
        if (attrs.containsKey((Object)Expectations.IssueAttribute.SECONDARY_LOCATIONS)) {
            List<AnalyzerMessage> actual = analyzerMessage.flows.stream().map(l -> l.isEmpty() ? null : (AnalyzerMessage)l.get(0)).filter(Objects::nonNull).collect(Collectors.toList());
            List expected = (List)attrs.get((Object)Expectations.IssueAttribute.SECONDARY_LOCATIONS);
            InternalCheckVerifier.validateSecondaryLocations(analyzerMessage, actual, expected);
        }
        if (attrs.containsKey((Object)Expectations.IssueAttribute.FLOWS)) {
            this.validateFlows(analyzerMessage.flows, (List)attrs.get((Object)Expectations.IssueAttribute.FLOWS));
        }
    }

    private static void validateSecondaryLocations(AnalyzerMessage parentIssue, List<AnalyzerMessage> actual, List<Integer> expected) {
        List actualLines = actual.stream().map(AnalyzerMessage::getLine).collect(Collectors.toList());
        ArrayList<Integer> unexpected = new ArrayList<Integer>();
        for (Integer actualLine : actualLines) {
            if (expected.contains(actualLine)) {
                expected.remove(actualLine);
                continue;
            }
            unexpected.add(actualLine);
        }
        if (!expected.isEmpty() || !unexpected.isEmpty()) {
            throw new AssertionError((Object)String.format("Secondary locations: expected: %s unexpected: %s. In %s:%d", expected, unexpected, ((InputFile)parentIssue.getInputComponent()).filename(), parentIssue.getLine()));
        }
    }

    private static void validateLocation(AnalyzerMessage analyzerMessage, Map<Expectations.IssueAttribute, Object> attrs) {
        AnalyzerMessage.TextSpan textSpan = analyzerMessage.primaryLocation();
        Objects.requireNonNull(textSpan);
        InternalCheckVerifier.assertAttributeMatch(analyzerMessage, InternalCheckVerifier.normalizeColumn(textSpan.startCharacter), attrs, Expectations.IssueAttribute.START_COLUMN);
        InternalCheckVerifier.assertAttributeMatch(analyzerMessage, textSpan.endLine, attrs, Expectations.IssueAttribute.END_LINE);
        InternalCheckVerifier.assertAttributeMatch(analyzerMessage, InternalCheckVerifier.normalizeColumn(textSpan.endCharacter), attrs, Expectations.IssueAttribute.END_COLUMN);
    }

    private static int normalizeColumn(int startCharacter) {
        return startCharacter + 1;
    }

    private void validateFlows(List<List<AnalyzerMessage>> actual, List<String> expectedFlowIds) {
        HashMap<String, List<AnalyzerMessage>> foundFlows = new HashMap<String, List<AnalyzerMessage>>();
        ArrayList<List<AnalyzerMessage>> unexpectedFlows = new ArrayList<List<AnalyzerMessage>>();
        actual.forEach(f -> this.validateFlow((List<AnalyzerMessage>)f, (Map<String, List<AnalyzerMessage>>)foundFlows, (List<List<AnalyzerMessage>>)unexpectedFlows));
        expectedFlowIds.removeAll(foundFlows.keySet());
        this.assertExpectedAndMissingFlows(expectedFlowIds, unexpectedFlows);
        this.validateFoundFlows(foundFlows);
    }

    private void assertExpectedAndMissingFlows(List<String> expectedFlowIds, List<List<AnalyzerMessage>> unexpectedFlows) {
        if (expectedFlowIds.size() == 1 && expectedFlowIds.size() == unexpectedFlows.size()) {
            this.assertSoleFlowDiscrepancy(expectedFlowIds.get(0), unexpectedFlows.get(0));
        }
        String unexpectedMsg = unexpectedFlows.stream().map(InternalCheckVerifier::flowToString).collect(Collectors.joining("\n"));
        String missingMsg = expectedFlowIds.stream().map(fid -> String.format("%s [%s]", fid, this.expectations.flowToLines((String)fid))).collect(Collectors.joining(","));
        if (!unexpectedMsg.isEmpty() || !missingMsg.isEmpty()) {
            unexpectedMsg = unexpectedMsg.isEmpty() ? "" : String.format("Unexpected flows: %s. ", unexpectedMsg);
            missingMsg = missingMsg.isEmpty() ? "" : String.format("Missing flows: %s.", missingMsg);
            throw new AssertionError((Object)(unexpectedMsg + missingMsg));
        }
    }

    private void assertSoleFlowDiscrepancy(String expectedId, List<AnalyzerMessage> actualFlow) {
        Set expected = this.expectations.flows.get(expectedId);
        List expectedLines = expected.stream().map(flow -> flow.line).collect(Collectors.toList());
        List actualLines = actualFlow.stream().map(AnalyzerMessage::getLine).collect(Collectors.toList());
        if (!actualLines.equals(expectedLines)) {
            throw new AssertionError((Object)String.format("Flow %s has line differences. Expected: %s but was: %s", expectedId, expectedLines, actualLines));
        }
    }

    private void validateFlow(List<AnalyzerMessage> flow, Map<String, List<AnalyzerMessage>> foundFlows, List<List<AnalyzerMessage>> unexpectedFlows) {
        Optional<String> flowId = this.expectations.containFlow(flow);
        if (flowId.isPresent()) {
            foundFlows.put(flowId.get(), flow);
        } else {
            unexpectedFlows.add(flow);
        }
    }

    private void validateFoundFlows(Map<String, List<AnalyzerMessage>> foundFlows) {
        foundFlows.forEach((flowId, flow) -> this.validateFlowAttributes((List<AnalyzerMessage>)flow, (String)flowId));
    }

    private void validateFlowAttributes(List<AnalyzerMessage> actual, String flowId) {
        SortedSet<Expectations.FlowComment> expected = this.expectations.flows.get(flowId);
        this.validateFlowMessages(actual, flowId, expected);
        Iterator<AnalyzerMessage> actualIterator = actual.iterator();
        Iterator expectedIterator = expected.iterator();
        while (actualIterator.hasNext() && expectedIterator.hasNext()) {
            AnalyzerMessage actualFlow = actualIterator.next();
            if (actualFlow.primaryLocation() == null) {
                throw new AssertionError((Object)String.format("Flow without location: %s", actualFlow));
            }
            InternalCheckVerifier.validateLocation(actualFlow, ((Expectations.FlowComment)expectedIterator.next()).attributes);
        }
    }

    private void validateFlowMessages(List<AnalyzerMessage> actual, String flowId, SortedSet<Expectations.FlowComment> expected) {
        List<String> actualMessages = actual.stream().map(AnalyzerMessage::getMessage).map(InternalCheckVerifier::addQuotes).collect(Collectors.toList());
        List<String> expectedMessages = expected.stream().map(Expectations.FlowComment::message).map(InternalCheckVerifier::addQuotes).collect(Collectors.toList());
        InternalCheckVerifier.replaceExpectedNullWithActual(actualMessages, expectedMessages);
        if (!actualMessages.equals(expectedMessages)) {
            throw new AssertionError((Object)String.format("Wrong messages in flow %s [%s]. Expected: %s but was: %s", flowId, this.expectations.flowToLines(flowId), expectedMessages, actualMessages));
        }
    }

    private static String addQuotes(@Nullable String s) {
        return s != null ? String.format("\"%s\"", s) : s;
    }

    private static void replaceExpectedNullWithActual(List<String> actualMessages, List<String> expectedMessages) {
        if (actualMessages.size() == expectedMessages.size()) {
            for (int i = 0; i < actualMessages.size(); ++i) {
                if (expectedMessages.get(i) != null) continue;
                expectedMessages.set(i, actualMessages.get(i));
            }
        }
    }

    private static String flowToString(List<AnalyzerMessage> flow) {
        return flow.stream().map(m -> String.valueOf(m.getLine())).collect(Collectors.joining(",", "[", "]"));
    }

    private static void requiresNull(@Nullable Object obj, String fieldName) {
        if (obj != null) {
            throw new AssertionError((Object)String.format("Do not set %s multiple times!", fieldName));
        }
    }

    private static void requiresNonNull(@Nullable Object obj, String fieldName) {
        if (obj == null) {
            throw new AssertionError((Object)String.format("Set %s before calling any verification method!", fieldName));
        }
    }

    private static void requiresNonEmpty(Collection<?> objects, String fieldName) {
        if (objects.isEmpty()) {
            throw new AssertionError((Object)String.format("Provide at least one %s!", fieldName));
        }
    }

    private static InputFile inputFile(File file) {
        try {
            return new TestInputFileBuilder("", file.getPath()).setContents(new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8)).setCharset(StandardCharsets.UTF_8).setLanguage("java").build();
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to read file '%s", file.getAbsolutePath()));
        }
    }

    private static SonarComponents sonarComponents() {
        SensorContextTester context = SensorContextTester.create((File)new File("")).setRuntime(SonarRuntimeImpl.forSonarLint((Version)Version.create((int)6, (int)7)));
        MapSettings settings = new MapSettings();
        DefaultFileSystem fileSystem = context.fileSystem();
        context.setSettings(settings.setProperty("sonar.internal.analysis.failFast", Boolean.valueOf(true)));
        ClasspathForMain classpathForMain = new ClasspathForMain(context.config(), (FileSystem)fileSystem);
        ClasspathForTest classpathForTest = new ClasspathForTest(context.config(), (FileSystem)fileSystem);
        SonarComponents sonarComponents = new SonarComponents(null, (FileSystem)fileSystem, classpathForMain, classpathForTest, null){

            public boolean reportAnalysisError(RecognitionException re, InputFile inputFile) {
                throw new AssertionError((Object)String.format("Should not fail analysis (%s)", re.getMessage()));
            }
        };
        sonarComponents.setSensorContext((SensorContext)context);
        return sonarComponents;
    }
}

