/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;

public class TestUtils {
    private static final String TEST_SOURCES_DIR = "../java-checks-test-sources/src/main/java/";
    private static final String NON_COMPILING_TEST_SOURCES_DIR = "../java-checks-test-sources/src/main/files/non-compiling/";

    private TestUtils() {
    }

    public static String testSourcesPath(String path) {
        return TestUtils.getFileFrom(path, TEST_SOURCES_DIR);
    }

    public static String nonCompilingTestSourcesPath(String path) {
        return TestUtils.getFileFrom(path, NON_COMPILING_TEST_SOURCES_DIR);
    }

    private static String getFileFrom(String path, String relocated) {
        File file = new File((relocated + path).replace('/', File.separatorChar));
        if (!file.exists()) {
            throw new IllegalStateException("Path '" + path + "' should exist.");
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalStateException("Invalid canonical path for '" + path + "'.", e);
        }
    }

    public static InputFile emptyInputFile(String filename) {
        return TestUtils.emptyInputFile(filename, InputFile.Type.MAIN);
    }

    public static InputFile emptyInputFile(String filename, InputFile.Type type) {
        return new TestInputFileBuilder("", filename).setCharset(StandardCharsets.UTF_8).setLanguage("java").setType(type).build();
    }

    public static InputFile inputFile(String filepath) {
        return TestUtils.inputFile("", new File(filepath));
    }

    public static InputFile inputFile(File file) {
        return TestUtils.inputFile("", file);
    }

    public static InputFile inputFile(String moduleKey, File file) {
        try {
            return new TestInputFileBuilder(moduleKey, file.getPath()).setContents(new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8)).setCharset(StandardCharsets.UTF_8).setLanguage("java").build();
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to read file '%s", file.getAbsolutePath()));
        }
    }
}

