/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier;

import java.io.File;
import java.io.IOException;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.java.checks.verifier.internal.InternalInputFile;

public class TestUtils {
    private static final String PROJECT_LOCATION = "../java-checks-test-sources/";
    private static final String MAIN_CODE_SOURCES_DIR = "../java-checks-test-sources/src/main/java/";
    private static final String TEST_CODE_SOURCES_DIR = "../java-checks-test-sources/src/test/java/";
    private static final String NON_COMPILING_TEST_SOURCES_DIR = "../java-checks-test-sources/src/main/files/non-compiling/";

    private TestUtils() {
    }

    @Deprecated(forRemoval=true)
    public static String testSourcesPath(String path) {
        return TestUtils.getFileFrom(path, MAIN_CODE_SOURCES_DIR);
    }

    public static String mainCodeSourcesPath(String path) {
        return TestUtils.getFileFrom(path, MAIN_CODE_SOURCES_DIR);
    }

    public static String testCodeSourcesPath(String path) {
        return TestUtils.getFileFrom(path, TEST_CODE_SOURCES_DIR);
    }

    public static String nonCompilingTestSourcesPath(String path) {
        return TestUtils.getFileFrom(path, NON_COMPILING_TEST_SOURCES_DIR);
    }

    private static String getFileFrom(String path, String relocated) {
        File file = new File((relocated + path).replace('/', File.separatorChar));
        if (!file.exists()) {
            throw new IllegalStateException("Path '" + path + "' should exist.");
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalStateException("Invalid canonical path for '" + path + "'.", e);
        }
    }

    public static InputFile emptyInputFile(String filename) {
        return InternalInputFile.emptyInputFile(filename, InputFile.Type.MAIN);
    }

    public static InputFile emptyInputFile(String filename, InputFile.Type type) {
        return InternalInputFile.emptyInputFile(filename, type);
    }

    public static InputFile inputFile(String filepath) {
        return InternalInputFile.inputFile("", new File(filepath));
    }

    public static InputFile inputFile(File file) {
        return InternalInputFile.inputFile("", file);
    }

    public static InputFile inputFile(String moduleKey, File file) {
        return InternalInputFile.inputFile(moduleKey, file);
    }
}

