/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.java.checks.verifier.internal.InternalWriteCache;

public class InternalReadCache
implements ReadCache {
    private final Map<String, byte[]> data = new HashMap<String, byte[]>();

    public InputStream read(String key) {
        if (!this.data.containsKey(key)) {
            throw new IllegalArgumentException(String.format("cache does not contain key \"%s\"", key));
        }
        byte[] buf = this.data.get(key);
        if (buf == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(buf);
    }

    public boolean contains(String key) {
        return this.data.containsKey(key);
    }

    public InternalReadCache put(String key, byte[] data) {
        this.data.put(key, data);
        return this;
    }

    public InternalReadCache putAll(Map<String, byte[]> data) {
        this.data.putAll(data);
        return this;
    }

    public InternalReadCache putAll(InternalWriteCache writeCache) {
        return this.putAll(writeCache.getData());
    }
}

