/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier;

import java.io.File;
import java.io.IOException;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.java.checks.verifier.internal.InternalInputFile;

public class TestUtils {
    public static final String DEFAULT_MODULE = "default";
    private static final String PROJECT_LOCATION = "../java-checks-test-sources/";

    private TestUtils() {
    }

    public static String mainCodeSourcesPath(String path) {
        return TestUtils.mainCodeSourcesPathInModule(DEFAULT_MODULE, path);
    }

    public static String mainCodeSourcesPathInModule(String module, String path) {
        return TestUtils.getFileFrom(path, PROJECT_LOCATION + module + "/src/main/java/");
    }

    public static String testCodeSourcesPath(String path) {
        return TestUtils.testCodeSourcesPathInModule(DEFAULT_MODULE, path);
    }

    public static String testCodeSourcesPathInModule(String module, String path) {
        return TestUtils.getFileFrom(path, PROJECT_LOCATION + module + "/src/test/java/");
    }

    public static String nonCompilingTestSourcesPath(String path) {
        return TestUtils.nonCompilingTestSourcesPathInModule(DEFAULT_MODULE, path);
    }

    public static String nonCompilingTestSourcesPathInModule(String module, String path) {
        return TestUtils.getFileFrom(path, PROJECT_LOCATION + module + "/src/main/files/non-compiling/");
    }

    private static String getFileFrom(String path, String relocated) {
        File file = new File((relocated + path).replace('/', File.separatorChar));
        if (!file.exists()) {
            throw new IllegalStateException("Path '" + path + "' should exist.");
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalStateException("Invalid canonical path for '" + path + "'.", e);
        }
    }

    public static InputFile emptyInputFile(String filename) {
        return InternalInputFile.emptyInputFile(filename, InputFile.Type.MAIN);
    }

    public static InputFile emptyInputFile(String filename, InputFile.Type type) {
        return InternalInputFile.emptyInputFile(filename, type);
    }

    public static InputFile inputFile(String filepath) {
        return InternalInputFile.inputFile("", new File(filepath));
    }

    public static InputFile inputFile(File file) {
        return InternalInputFile.inputFile("", file);
    }

    public static InputFile inputFile(String moduleKey, File file) {
        return InternalInputFile.inputFile(moduleKey, file);
    }
}

