/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier.internal;

import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.api.batch.sensor.cache.WriteCache;
import org.sonar.api.config.Configuration;
import org.sonar.java.SonarComponents;
import org.sonar.java.annotations.Beta;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.ast.JavaAstScanner;
import org.sonar.java.caching.DummyCache;
import org.sonar.java.caching.JavaReadCacheImpl;
import org.sonar.java.caching.JavaWriteCacheImpl;
import org.sonar.java.checks.verifier.CheckVerifier;
import org.sonar.java.checks.verifier.internal.CacheEnabledSensorContext;
import org.sonar.java.checks.verifier.internal.Expectations;
import org.sonar.java.checks.verifier.internal.InternalCacheContext;
import org.sonar.java.checks.verifier.internal.InternalInputFile;
import org.sonar.java.checks.verifier.internal.InternalSensorContext;
import org.sonar.java.classpath.ClasspathForMain;
import org.sonar.java.classpath.ClasspathForTest;
import org.sonar.java.model.JavaVersionImpl;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.java.test.classpath.TestClasspathUtils;
import org.sonar.java.testing.JavaFileScannerContextForTests;
import org.sonar.java.testing.VisitorsBridgeForTests;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.caching.CacheContext;
import org.sonar.plugins.java.api.caching.JavaReadCache;
import org.sonar.plugins.java.api.caching.JavaWriteCache;

public class InternalCheckVerifier
implements CheckVerifier {
    private static final String CHECK_OR_CHECKS = "check(s)";
    private static final String FILE_OR_FILES = "file(s)";
    private static final JavaVersion DEFAULT_JAVA_VERSION = new JavaVersionImpl();
    private static final List<File> DEFAULT_CLASSPATH;
    private boolean withoutSemantic = false;
    private List<JavaFileScanner> checks = null;
    private List<InputFile> files = null;
    private JavaVersion javaVersion = null;
    private boolean inAndroidContext = false;
    private boolean isCacheEnabled = false;
    private List<File> classpath = null;
    private Consumer<Set<AnalyzerMessage>> customIssueVerifier = null;
    private boolean collectQuickFixes = false;
    private Expectations expectations = new Expectations();
    @VisibleForTesting
    CacheContext cacheContext = null;
    private ReadCache readCache;
    private WriteCache writeCache;

    private InternalCheckVerifier() {
    }

    public static InternalCheckVerifier newInstance() {
        return new InternalCheckVerifier();
    }

    @Override
    public InternalCheckVerifier withCheck(JavaFileScanner check) {
        InternalCheckVerifier.requiresNull(this.checks, CHECK_OR_CHECKS);
        this.checks = Collections.singletonList(check);
        return this;
    }

    @Override
    public InternalCheckVerifier withChecks(JavaFileScanner ... checks) {
        InternalCheckVerifier.requiresNull(this.checks, CHECK_OR_CHECKS);
        InternalCheckVerifier.requiresNonEmpty(Arrays.asList(checks), "check");
        this.checks = Arrays.asList(checks);
        return this;
    }

    @Override
    public InternalCheckVerifier withClassPath(Collection<File> classpath) {
        InternalCheckVerifier.requiresNull(this.classpath, "classpath");
        this.classpath = new ArrayList<File>(classpath);
        return this;
    }

    @Beta
    public InternalCheckVerifier withCustomIssueVerifier(Consumer<Set<AnalyzerMessage>> customIssueVerifier) {
        InternalCheckVerifier.requiresNull(this.customIssueVerifier, "custom issue verifier");
        this.customIssueVerifier = customIssueVerifier;
        return this;
    }

    @Beta
    public InternalCheckVerifier withQuickFixes() {
        this.collectQuickFixes = true;
        this.expectations.setCollectQuickFixes();
        return this;
    }

    @Override
    public InternalCheckVerifier withJavaVersion(int javaVersionAsInt) {
        InternalCheckVerifier.requiresNull(this.javaVersion, "java version");
        return this.withJavaVersion(javaVersionAsInt, false);
    }

    @Override
    public InternalCheckVerifier withJavaVersion(int javaVersionAsInt, boolean enablePreviewFeatures) {
        InternalCheckVerifier.requiresNull(this.javaVersion, "java version");
        if (enablePreviewFeatures && javaVersionAsInt != 19) {
            String message = String.format("Preview features can only be enabled when the version == latest supported Java version (%d != %d)", javaVersionAsInt, 19);
            throw new IllegalArgumentException(message);
        }
        this.javaVersion = new JavaVersionImpl(javaVersionAsInt, enablePreviewFeatures);
        return this;
    }

    @Override
    public CheckVerifier withinAndroidContext(boolean inAndroidContext) {
        this.inAndroidContext = inAndroidContext;
        return this;
    }

    @Override
    public InternalCheckVerifier onFile(String filename) {
        InternalCheckVerifier.requiresNull(this.files, FILE_OR_FILES);
        return this.onFiles(Collections.singletonList(filename));
    }

    @Override
    public InternalCheckVerifier onFiles(String ... filenames) {
        List<String> asList = Arrays.asList(filenames);
        InternalCheckVerifier.requiresNonEmpty(asList, "file");
        return this.onFiles(Arrays.asList(filenames));
    }

    @Override
    public InternalCheckVerifier onFiles(Collection<String> filenames) {
        InternalCheckVerifier.requiresNull(this.files, FILE_OR_FILES);
        InternalCheckVerifier.requiresNonEmpty(filenames, "file");
        this.files = new ArrayList<InputFile>();
        return this.addFiles(InputFile.Status.SAME, (Collection)filenames);
    }

    @Override
    public InternalCheckVerifier addFiles(InputFile.Status status, String ... modifiedFileNames) {
        return this.addFiles(status, Arrays.asList(modifiedFileNames));
    }

    @Override
    public InternalCheckVerifier addFiles(InputFile.Status status, Collection<String> modifiedFileNames) {
        InternalCheckVerifier.requiresNonEmpty(modifiedFileNames, "file");
        if (this.files == null) {
            this.files = new ArrayList<InputFile>(modifiedFileNames.size());
        }
        List filesToAdd = modifiedFileNames.stream().map(name -> InternalInputFile.inputFile("", new File((String)name), status)).collect(Collectors.toList());
        List filesToAddStrings = filesToAdd.stream().map(Object::toString).collect(Collectors.toList());
        this.files.forEach(inputFile -> {
            if (filesToAddStrings.contains(inputFile.toString())) {
                throw new IllegalArgumentException(String.format("File %s was already added.", inputFile));
            }
        });
        this.files.addAll(filesToAdd);
        return this;
    }

    @Override
    public InternalCheckVerifier withoutSemantic() {
        this.withoutSemantic = true;
        return this;
    }

    @Override
    public CheckVerifier withCache(@Nullable ReadCache readCache, @Nullable WriteCache writeCache) {
        this.isCacheEnabled = true;
        this.readCache = readCache;
        this.writeCache = writeCache;
        this.cacheContext = new InternalCacheContext(true, (JavaReadCache)(readCache == null ? new DummyCache() : new JavaReadCacheImpl(readCache)), (JavaWriteCache)(writeCache == null ? new DummyCache() : new JavaWriteCacheImpl(writeCache)));
        return this;
    }

    @Override
    public void verifyIssues() {
        InternalCheckVerifier.requiresNonNull(this.checks, CHECK_OR_CHECKS);
        InternalCheckVerifier.requiresNonNull(this.files, FILE_OR_FILES);
        this.verifyAll();
    }

    @Override
    public void verifyIssueOnFile(String expectedIssueMessage) {
        InternalCheckVerifier.requiresNonNull(this.checks, CHECK_OR_CHECKS);
        InternalCheckVerifier.requiresNonNull(this.files, FILE_OR_FILES);
        this.expectations.setExpectedFileIssue(expectedIssueMessage);
        this.verifyAll();
    }

    @Override
    public void verifyIssueOnProject(String expectedIssueMessage) {
        InternalCheckVerifier.requiresNonNull(this.checks, CHECK_OR_CHECKS);
        InternalCheckVerifier.requiresNonNull(this.files, FILE_OR_FILES);
        this.expectations.setExpectedProjectIssue(expectedIssueMessage);
        this.verifyAll();
    }

    @Override
    public void verifyNoIssues() {
        InternalCheckVerifier.requiresNonNull(this.checks, CHECK_OR_CHECKS);
        InternalCheckVerifier.requiresNonNull(this.files, FILE_OR_FILES);
        this.expectations.setExpectNoIssues();
        this.verifyAll();
    }

    private void verifyAll() {
        VisitorsBridgeForTests visitorsBridge;
        JavaVersion actualVersion;
        ArrayList<JavaFileScanner> visitors = new ArrayList<JavaFileScanner>(this.checks);
        if (this.withoutSemantic && this.expectations.expectNoIssues()) {
            visitors.add((JavaFileScanner)this.expectations.noEffectParser());
        } else {
            visitors.add((JavaFileScanner)this.expectations.parser());
        }
        SonarComponents sonarComponents = this.sonarComponents();
        JavaVersion javaVersion = actualVersion = this.javaVersion == null ? DEFAULT_JAVA_VERSION : this.javaVersion;
        if (this.withoutSemantic) {
            visitorsBridge = new VisitorsBridgeForTests(visitors, sonarComponents, actualVersion);
        } else {
            List<File> actualClasspath = this.classpath == null ? DEFAULT_CLASSPATH : this.classpath;
            visitorsBridge = new VisitorsBridgeForTests(visitors, actualClasspath, sonarComponents, actualVersion);
        }
        JavaAstScanner astScanner = new JavaAstScanner(sonarComponents);
        visitorsBridge.setInAndroidContext(this.inAndroidContext);
        astScanner.setVisitorBridge((VisitorsBridge)visitorsBridge);
        List filesToParse = this.files;
        if (this.isCacheEnabled) {
            visitorsBridge.setCacheContext(this.cacheContext);
            filesToParse = (List)astScanner.scanWithoutParsing(this.files).get(false);
        }
        astScanner.scan(filesToParse);
        JavaFileScannerContextForTests testJavaFileScannerContext = visitorsBridge.lastCreatedTestContext();
        JavaFileScannerContextForTests testModuleScannerContext = visitorsBridge.lastCreatedModuleContext();
        if (testJavaFileScannerContext != null) {
            LinkedHashSet<AnalyzerMessage> issues = new LinkedHashSet<AnalyzerMessage>(testJavaFileScannerContext.getIssues());
            issues.addAll(testModuleScannerContext.getIssues());
            HashMap<AnalyzerMessage.TextSpan, List<JavaQuickFix>> quickFixes = new HashMap<AnalyzerMessage.TextSpan, List<JavaQuickFix>>(testJavaFileScannerContext.getQuickFixes());
            quickFixes.putAll(testModuleScannerContext.getQuickFixes());
            this.checkIssues(issues, quickFixes);
        } else {
            this.checkIssues(Collections.emptySet(), Collections.emptyMap());
        }
    }

    private void checkIssues(Set<AnalyzerMessage> issues, Map<AnalyzerMessage.TextSpan, List<JavaQuickFix>> quickFixes) {
        if (this.expectations.expectNoIssues()) {
            InternalCheckVerifier.assertNoIssues(issues);
        } else if (this.expectations.expectIssueAtFileLevel() || this.expectations.expectIssueAtProjectLevel()) {
            this.assertComponentIssue(issues);
        } else {
            this.assertMultipleIssues(issues, quickFixes);
        }
        if (this.customIssueVerifier != null) {
            this.customIssueVerifier.accept(issues);
        }
    }

    private static void assertNoIssues(Set<AnalyzerMessage> issues) {
        if (issues.isEmpty()) {
            return;
        }
        String issuesAsString = issues.stream().sorted(InternalCheckVerifier.issueLineSorter()).map(issue -> String.format("'%s' in %s%s", issue.getMessage(), issue.getInputComponent(), issue.getLine() == null ? "" : ":" + issue.getLine())).collect(Collectors.joining("\n--> ", "\n--> ", ""));
        throw new AssertionError((Object)String.format("No issues expected but got %d issue(s):%s", issues.size(), issuesAsString));
    }

    private static Comparator<? super AnalyzerMessage> issueLineSorter() {
        return (i1, i2) -> {
            if (i1.getLine() == null) {
                return 1;
            }
            if (i2.getLine() == null) {
                return -1;
            }
            return Integer.compare(i1.getLine(), i2.getLine());
        };
    }

    private void assertComponentIssue(Set<AnalyzerMessage> issues) {
        String expectedMessage = this.expectations.expectedFileIssue();
        String component = "file";
        String otherComponent = "project";
        if (this.expectations.expectIssueAtProjectLevel()) {
            expectedMessage = this.expectations.expectedProjectIssue();
            component = "project";
            otherComponent = "file";
        }
        if (issues.size() != 1) {
            String issueNumberMessage = issues.isEmpty() ? "none has been raised" : String.format("%d issues have been raised", issues.size());
            throw new AssertionError((Object)String.format("A single issue is expected on the %s, but %s", component, issueNumberMessage));
        }
        AnalyzerMessage issue = issues.iterator().next();
        if (issue.getLine() != null) {
            throw new AssertionError((Object)String.format("Expected an issue directly on %s but was raised on line %d", component, issue.getLine()));
        }
        if (this.expectations.expectIssueAtProjectLevel() && issue.getInputComponent().isFile() || this.expectations.expectIssueAtFileLevel() && !issue.getInputComponent().isFile()) {
            throw new AssertionError((Object)String.format("Expected the issue to be raised at %s level, not at %s level", component, otherComponent));
        }
        if (!expectedMessage.equals(issue.getMessage())) {
            throw new AssertionError((Object)String.format("Expected the issue message to be:%n\t\"%s\"%nbut was:%n\t\"%s\"", expectedMessage, issue.getMessage()));
        }
    }

    private void assertMultipleIssues(Set<AnalyzerMessage> issues, Map<AnalyzerMessage.TextSpan, List<JavaQuickFix>> quickFixes) throws AssertionError {
        if (issues.isEmpty()) {
            throw new AssertionError((Object)"No issue raised. At least one issue expected");
        }
        LinkedList<Integer> unexpectedLines = new LinkedList<Integer>();
        Expectations.RemediationFunction remediationFunction = Expectations.remediationFunction(issues.iterator().next());
        Map<Integer, List<Expectations.Issue>> expected = this.expectations.issues;
        for (AnalyzerMessage issue : issues) {
            this.validateIssue(expected, unexpectedLines, issue, remediationFunction);
        }
        if (!expected.isEmpty() || !unexpectedLines.isEmpty()) {
            Collections.sort(unexpectedLines);
            List expectedLines = expected.keySet().stream().sorted().collect(Collectors.toList());
            throw new AssertionError((Object)((expectedLines.isEmpty() ? "" : String.format("Expected at %s", expectedLines)) + (expectedLines.isEmpty() || unexpectedLines.isEmpty() ? "" : ", ") + (unexpectedLines.isEmpty() ? "" : String.format("Unexpected at %s", unexpectedLines))));
        }
        this.assertSuperfluousFlows();
        if (this.collectQuickFixes) {
            new QuickFixesVerifier(this.expectations.quickFixes(), quickFixes).accept(issues);
        }
    }

    private void validateIssue(Map<Integer, List<Expectations.Issue>> expected, List<Integer> unexpectedLines, AnalyzerMessage issue, @Nullable Expectations.RemediationFunction remediationFunction) {
        int line = issue.getLine();
        if (expected.containsKey(line)) {
            Expectations.Issue attrs = expected.get(line).get(0);
            InternalCheckVerifier.validateRemediationFunction(attrs, issue, remediationFunction);
            this.validateAnalyzerMessageAttributes(attrs, issue);
            expected.computeIfPresent(line, (l, issues) -> {
                issues.remove(attrs);
                return issues.isEmpty() ? null : issues;
            });
        } else {
            unexpectedLines.add(line);
        }
    }

    private static void validateRemediationFunction(Expectations.Issue attributes, AnalyzerMessage issue, @Nullable Expectations.RemediationFunction remediationFunction) {
        if (remediationFunction == null) {
            return;
        }
        Double effortToFix = issue.getCost();
        if (effortToFix != null) {
            if (remediationFunction == Expectations.RemediationFunction.CONST) {
                throw new AssertionError((Object)"Rule with constant remediation function shall not provide cost");
            }
            InternalCheckVerifier.assertAttributeMatch(issue, effortToFix, attributes, Expectations.IssueAttribute.EFFORT_TO_FIX);
        } else if (remediationFunction == Expectations.RemediationFunction.LINEAR) {
            throw new AssertionError((Object)"A cost should be provided for a rule with linear remediation function");
        }
    }

    private void assertSuperfluousFlows() {
        Set<String> unseenFlowIds = this.expectations.unseenFlowIds();
        Map unseenFlowWithLines = unseenFlowIds.stream().collect(Collectors.toMap(Function.identity(), this.expectations::flowToLines));
        if (!unseenFlowWithLines.isEmpty()) {
            throw new AssertionError((Object)String.format("Following flow comments were observed, but not referenced by any issue: %s", unseenFlowWithLines));
        }
    }

    private static void assertAttributeMatch(AnalyzerMessage issue, Object value, Map<Expectations.IssueAttribute, Object> attributes, Expectations.IssueAttribute attribute) {
        if (attributes.containsKey((Object)attribute) && !value.equals(attribute.get(attributes))) {
            throw new AssertionError((Object)String.format("line %d attribute mismatch for '%s'. Expected: '%s', but was: '%s'", new Object[]{issue.getLine(), attribute, attribute.get(attributes), value}));
        }
    }

    private void validateAnalyzerMessageAttributes(Expectations.Issue attrs, AnalyzerMessage analyzerMessage) {
        InternalCheckVerifier.assertAttributeMatch(analyzerMessage, analyzerMessage.getMessage(), attrs, Expectations.IssueAttribute.MESSAGE);
        InternalCheckVerifier.validateLocation(analyzerMessage, attrs);
        if (attrs.containsKey((Object)Expectations.IssueAttribute.SECONDARY_LOCATIONS)) {
            List<AnalyzerMessage> actual = analyzerMessage.flows.stream().map(l -> l.isEmpty() ? null : (AnalyzerMessage)l.get(0)).filter(Objects::nonNull).collect(Collectors.toList());
            List expected = (List)attrs.get((Object)Expectations.IssueAttribute.SECONDARY_LOCATIONS);
            InternalCheckVerifier.validateSecondaryLocations(analyzerMessage, actual, expected);
        }
        if (attrs.containsKey((Object)Expectations.IssueAttribute.FLOWS)) {
            this.validateFlows(analyzerMessage.flows, (List)attrs.get((Object)Expectations.IssueAttribute.FLOWS));
        }
    }

    private static void validateSecondaryLocations(AnalyzerMessage parentIssue, List<AnalyzerMessage> actual, List<Integer> expected) {
        List actualLines = actual.stream().map(AnalyzerMessage::getLine).collect(Collectors.toList());
        ArrayList<Integer> unexpected = new ArrayList<Integer>();
        for (Integer actualLine : actualLines) {
            if (expected.contains(actualLine)) {
                expected.remove(actualLine);
                continue;
            }
            unexpected.add(actualLine);
        }
        if (!expected.isEmpty() || !unexpected.isEmpty()) {
            throw new AssertionError((Object)String.format("Secondary locations: expected: %s unexpected: %s. In %s:%d", expected, unexpected, ((InputFile)parentIssue.getInputComponent()).filename(), parentIssue.getLine()));
        }
    }

    private static void validateLocation(AnalyzerMessage analyzerMessage, Map<Expectations.IssueAttribute, Object> attrs) {
        AnalyzerMessage.TextSpan textSpan = analyzerMessage.primaryLocation();
        Objects.requireNonNull(textSpan);
        InternalCheckVerifier.assertAttributeMatch(analyzerMessage, InternalCheckVerifier.normalizeColumn(textSpan.startCharacter), attrs, Expectations.IssueAttribute.START_COLUMN);
        InternalCheckVerifier.assertAttributeMatch(analyzerMessage, textSpan.endLine, attrs, Expectations.IssueAttribute.END_LINE);
        InternalCheckVerifier.assertAttributeMatch(analyzerMessage, InternalCheckVerifier.normalizeColumn(textSpan.endCharacter), attrs, Expectations.IssueAttribute.END_COLUMN);
    }

    private static int normalizeColumn(int startCharacter) {
        return startCharacter + 1;
    }

    private void validateFlows(List<List<AnalyzerMessage>> actual, List<String> expectedFlowIds) {
        HashMap<String, List<AnalyzerMessage>> foundFlows = new HashMap<String, List<AnalyzerMessage>>();
        ArrayList<List<AnalyzerMessage>> unexpectedFlows = new ArrayList<List<AnalyzerMessage>>();
        actual.forEach(f -> this.validateFlow((List<AnalyzerMessage>)f, (Map<String, List<AnalyzerMessage>>)foundFlows, (List<List<AnalyzerMessage>>)unexpectedFlows));
        expectedFlowIds.removeAll(foundFlows.keySet());
        this.assertExpectedAndMissingFlows(expectedFlowIds, unexpectedFlows);
        this.validateFoundFlows(foundFlows);
    }

    private void assertExpectedAndMissingFlows(List<String> expectedFlowIds, List<List<AnalyzerMessage>> unexpectedFlows) {
        if (expectedFlowIds.size() == 1 && expectedFlowIds.size() == unexpectedFlows.size()) {
            this.assertSoleFlowDiscrepancy(expectedFlowIds.get(0), unexpectedFlows.get(0));
        }
        String unexpectedMsg = unexpectedFlows.stream().map(InternalCheckVerifier::flowToString).collect(Collectors.joining("\n"));
        String missingMsg = expectedFlowIds.stream().map(fid -> String.format("%s [%s]", fid, this.expectations.flowToLines((String)fid))).collect(Collectors.joining(","));
        if (!unexpectedMsg.isEmpty() || !missingMsg.isEmpty()) {
            unexpectedMsg = unexpectedMsg.isEmpty() ? "" : String.format("Unexpected flows: %s. ", unexpectedMsg);
            missingMsg = missingMsg.isEmpty() ? "" : String.format("Missing flows: %s.", missingMsg);
            throw new AssertionError((Object)(unexpectedMsg + missingMsg));
        }
    }

    private void assertSoleFlowDiscrepancy(String expectedId, List<AnalyzerMessage> actualFlow) {
        Set expected = this.expectations.flows.get(expectedId);
        List expectedLines = expected.stream().map(flow -> flow.line).collect(Collectors.toList());
        List actualLines = actualFlow.stream().map(AnalyzerMessage::getLine).collect(Collectors.toList());
        if (!actualLines.equals(expectedLines)) {
            throw new AssertionError((Object)String.format("Flow %s has line differences. Expected: %s but was: %s", expectedId, expectedLines, actualLines));
        }
    }

    private void validateFlow(List<AnalyzerMessage> flow, Map<String, List<AnalyzerMessage>> foundFlows, List<List<AnalyzerMessage>> unexpectedFlows) {
        Optional<String> flowId = this.expectations.containFlow(flow);
        if (flowId.isPresent()) {
            foundFlows.put(flowId.get(), flow);
        } else {
            unexpectedFlows.add(flow);
        }
    }

    private void validateFoundFlows(Map<String, List<AnalyzerMessage>> foundFlows) {
        foundFlows.forEach((flowId, flow) -> this.validateFlowAttributes((List<AnalyzerMessage>)flow, (String)flowId));
    }

    private void validateFlowAttributes(List<AnalyzerMessage> actual, String flowId) {
        SortedSet<Expectations.FlowComment> expected = this.expectations.flows.get(flowId);
        this.validateFlowMessages(actual, flowId, expected);
        Iterator<AnalyzerMessage> actualIterator = actual.iterator();
        Iterator expectedIterator = expected.iterator();
        while (actualIterator.hasNext() && expectedIterator.hasNext()) {
            AnalyzerMessage actualFlow = actualIterator.next();
            if (actualFlow.primaryLocation() == null) {
                throw new AssertionError((Object)String.format("Flow without location: %s", actualFlow));
            }
            InternalCheckVerifier.validateLocation(actualFlow, ((Expectations.FlowComment)expectedIterator.next()).attributes);
        }
    }

    private void validateFlowMessages(List<AnalyzerMessage> actual, String flowId, SortedSet<Expectations.FlowComment> expected) {
        List<String> actualMessages = actual.stream().map(AnalyzerMessage::getMessage).map(InternalCheckVerifier::addQuotes).collect(Collectors.toList());
        List<String> expectedMessages = expected.stream().map(Expectations.FlowComment::message).map(InternalCheckVerifier::addQuotes).collect(Collectors.toList());
        InternalCheckVerifier.replaceExpectedNullWithActual(actualMessages, expectedMessages);
        if (!actualMessages.equals(expectedMessages)) {
            throw new AssertionError((Object)String.format("Wrong messages in flow %s [%s]. Expected: %s but was: %s", flowId, this.expectations.flowToLines(flowId), expectedMessages, actualMessages));
        }
    }

    private static String addQuotes(@Nullable String s) {
        return s != null ? String.format("\"%s\"", s) : s;
    }

    private static void replaceExpectedNullWithActual(List<String> actualMessages, List<String> expectedMessages) {
        if (actualMessages.size() == expectedMessages.size()) {
            for (int i = 0; i < actualMessages.size(); ++i) {
                if (expectedMessages.get(i) != null) continue;
                expectedMessages.set(i, actualMessages.get(i));
            }
        }
    }

    private static String flowToString(List<AnalyzerMessage> flow) {
        return flow.stream().map(m -> String.valueOf(m.getLine())).collect(Collectors.joining(",", "[", "]"));
    }

    private static void requiresNull(@Nullable Object obj, String fieldName) {
        if (obj != null) {
            throw new AssertionError((Object)String.format("Do not set %s multiple times!", fieldName));
        }
    }

    private static void requiresNonNull(@Nullable Object obj, String fieldName) {
        if (obj == null) {
            throw new AssertionError((Object)String.format("Set %s before calling any verification method!", fieldName));
        }
    }

    private static void requiresNonEmpty(Collection<?> objects, String fieldName) {
        if (objects.isEmpty()) {
            throw new AssertionError((Object)String.format("Provide at least one %s!", fieldName));
        }
    }

    private SonarComponents sonarComponents() {
        InternalSensorContext sensorContext = this.isCacheEnabled ? new CacheEnabledSensorContext(this.readCache, this.writeCache) : new InternalSensorContext();
        FileSystem fileSystem = sensorContext.fileSystem();
        Configuration config = sensorContext.config();
        ClasspathForMain classpathForMain = new ClasspathForMain(config, fileSystem);
        ClasspathForTest classpathForTest = new ClasspathForTest(config, fileSystem);
        SonarComponents sonarComponents = new SonarComponents(null, fileSystem, classpathForMain, classpathForTest, null, null){

            public boolean reportAnalysisError(RecognitionException re, InputFile inputFile) {
                throw new AssertionError((Object)String.format("Should not fail analysis (%s)", re.getMessage()));
            }

            public boolean canSkipUnchangedFiles() {
                return InternalCheckVerifier.this.isCacheEnabled;
            }
        };
        sonarComponents.setSensorContext((SensorContext)sensorContext);
        return sonarComponents;
    }

    static {
        Path path = Paths.get("../java-checks-test-sources/default/target/test-classpath.txt".replace('/', File.separatorChar), new String[0]);
        DEFAULT_CLASSPATH = Files.exists(path, new LinkOption[0]) ? TestClasspathUtils.loadFromFile((String)path.toString()) : new ArrayList();
        Optional.of(new File("../java-checks-test-sources/default/target/classes")).filter(File::exists).ifPresent(DEFAULT_CLASSPATH::add);
    }

    private static class QuickFixesVerifier
    implements Consumer<Set<AnalyzerMessage>> {
        private final Map<AnalyzerMessage.TextSpan, List<JavaQuickFix>> expectedQuickFixes;
        private final Map<AnalyzerMessage.TextSpan, List<JavaQuickFix>> actualQuickFixes;

        public QuickFixesVerifier(Map<AnalyzerMessage.TextSpan, List<JavaQuickFix>> expectedQuickFixes, Map<AnalyzerMessage.TextSpan, List<JavaQuickFix>> actualQuickFixes) {
            this.expectedQuickFixes = expectedQuickFixes;
            this.actualQuickFixes = actualQuickFixes;
        }

        @Override
        public void accept(Set<AnalyzerMessage> issues) {
            for (AnalyzerMessage issue : issues) {
                AnalyzerMessage.TextSpan primaryLocation = issue.primaryLocation();
                List<JavaQuickFix> expected = this.expectedQuickFixes.get(primaryLocation);
                if (expected == null) continue;
                List<JavaQuickFix> actual = this.actualQuickFixes.get(primaryLocation);
                if (expected.isEmpty()) {
                    if (actual != null && !actual.isEmpty()) {
                        throw new AssertionError((Object)String.format("[Quick Fix] Issue on line %d contains quick fixes while none where expected", primaryLocation.startLine));
                    }
                    continue;
                }
                QuickFixesVerifier.validateIfSameSize(expected, actual, issue);
            }
        }

        private static void validateIfSameSize(List<JavaQuickFix> expected, @Nullable List<JavaQuickFix> actual, AnalyzerMessage issue) {
            int expectedSize;
            AnalyzerMessage.TextSpan primaryLocation = issue.primaryLocation();
            if (actual == null || actual.isEmpty()) {
                throw new AssertionError((Object)String.format("[Quick Fix] Missing quick fix for issue on line %d", primaryLocation.startLine));
            }
            int actualSize = actual.size();
            if (actualSize != (expectedSize = expected.size())) {
                throw new AssertionError((Object)String.format("[Quick Fix] Number of quickfixes expected is not equal to the number of expected on line %d: expected: %d , actual: %d", primaryLocation.startLine, expectedSize, actualSize));
            }
            for (int i = 0; i < actualSize; ++i) {
                QuickFixesVerifier.validate(issue, actual.get(i), expected.get(i));
            }
        }

        private static void validate(AnalyzerMessage actualIssue, JavaQuickFix actual, JavaQuickFix expected) {
            String expectedDescription;
            String actualDescription = actual.getDescription();
            if (!actualDescription.equals(expectedDescription = expected.getDescription())) {
                throw new AssertionError((Object)String.format("[Quick Fix] Wrong description for issue on line %d.%nExpected: {{%s}}%nbut was:     {{%s}}", actualIssue.getLine(), expectedDescription, actualDescription));
            }
            List actualTextEdits = actual.getTextEdits();
            List expectedTextEdits = expected.getTextEdits();
            if (actualTextEdits.size() != expectedTextEdits.size()) {
                throw new AssertionError((Object)String.format("[Quick Fix] Wrong number of edits for issue on line %d.%nExpected: {{%d}}%nbut was:     {{%d}}", actualIssue.getLine(), expectedTextEdits.size(), actualTextEdits.size()));
            }
            for (int i = 0; i < actualTextEdits.size(); ++i) {
                JavaTextEdit actualTextEdit = (JavaTextEdit)actualTextEdits.get(i);
                JavaTextEdit expectedTextEdit = (JavaTextEdit)expectedTextEdits.get(i);
                String expectedReplacement = expectedTextEdit.getReplacement();
                String actualReplacement = actualTextEdit.getReplacement();
                if (expectedReplacement.contains("\\n")) {
                    expectedReplacement = expectedReplacement.replace("\\n", "\n");
                }
                if (!actualReplacement.equals(expectedReplacement)) {
                    throw new AssertionError((Object)String.format("[Quick Fix] Wrong text replacement of edit %d for issue on line %d.%nExpected: {{%s}}%nbut was:     {{%s}}", i + 1, actualIssue.getLine(), expectedReplacement, actualReplacement));
                }
                AnalyzerMessage.TextSpan actualNormalizedTextSpan = actualTextEdit.getTextSpan();
                if (!actualNormalizedTextSpan.equals((Object)expectedTextEdit.getTextSpan())) {
                    throw new AssertionError((Object)String.format("[Quick Fix] Wrong change location of edit %d for issue on line %d.%nExpected: {{%s}}%nbut was:     {{%s}}", i + 1, actualIssue.getLine(), QuickFixesVerifier.editorTextSpan(expectedTextEdit.getTextSpan()), QuickFixesVerifier.editorTextSpan(actualNormalizedTextSpan)));
                }
            }
        }

        private static AnalyzerMessage.TextSpan editorTextSpan(AnalyzerMessage.TextSpan textSpan) {
            return new AnalyzerMessage.TextSpan(textSpan.startLine, textSpan.startCharacter + 1, textSpan.endLine, textSpan.endCharacter + 1);
        }
    }
}

