/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.sonar.java.annotations.VisibleForTesting;

public final class FilesUtils {
    public static final String TEST_SOURCES_ROOT = "../java-checks-test-sources/";
    public static final String TARGET_TEST_CLASSPATH_FILE = "/target/test-classpath.txt";
    public static final String TARGET_CLASSES = "/target/classes";
    public static final String DEFAULT_TEST_CLASSPATH_FILE = "../java-checks-test-sources/default/target/test-classpath.txt";
    public static final String DEFAULT_TEST_CLASSES_DIRECTORY = "../java-checks-test-sources/default/target/classes";

    private FilesUtils() {
    }

    @VisibleForTesting
    public static List<File> getFilesRecursively(Path root, final String ... extensions) {
        final ArrayList files = new ArrayList();
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) {
                for (String extension : extensions) {
                    if (!filePath.toString().endsWith("." + extension)) continue;
                    files.add(filePath.toFile());
                    break;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)visitor);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return files.stream().sorted().toList();
    }
}

