/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleAnnotationUtils;
import org.sonar.plugins.java.api.CheckRegistrar;
import org.sonar.plugins.java.api.JavaCheck;

public class TestCheckRegistrarContext
extends CheckRegistrar.RegistrarContext {
    public final List<Class<? extends JavaCheck>> mainCheckClasses = new ArrayList<Class<? extends JavaCheck>>();
    public final List<JavaCheck> mainCheckInstances = new ArrayList<JavaCheck>();
    public final List<RuleKey> mainRuleKeys = new ArrayList<RuleKey>();
    public final List<Class<? extends JavaCheck>> testCheckClasses = new ArrayList<Class<? extends JavaCheck>>();
    public final List<JavaCheck> testCheckInstances = new ArrayList<JavaCheck>();
    public final List<RuleKey> testRuleKeys = new ArrayList<RuleKey>();
    public final Set<RuleKey> autoScanCompatibleRules = new HashSet<RuleKey>();

    public void registerMainChecks(String repositoryKey, Collection<?> javaCheckClassesAndInstances) {
        TestCheckRegistrarContext.validateAndRegisterChecks(repositoryKey, javaCheckClassesAndInstances, this.mainCheckClasses, this.mainCheckInstances, this.mainRuleKeys);
    }

    public void registerTestChecks(String repositoryKey, Collection<?> javaCheckClassesAndInstances) {
        TestCheckRegistrarContext.validateAndRegisterChecks(repositoryKey, javaCheckClassesAndInstances, this.testCheckClasses, this.testCheckInstances, this.testRuleKeys);
    }

    public void registerMainSharedCheck(JavaCheck check, Collection<RuleKey> ruleKeys) {
        this.mainCheckClasses.add(check.getClass());
        this.mainCheckInstances.add(check);
        this.mainRuleKeys.addAll(ruleKeys);
    }

    public void registerTestSharedCheck(JavaCheck check, Collection<RuleKey> ruleKeys) {
        this.testCheckClasses.add(check.getClass());
        this.testCheckInstances.add(check);
        this.testRuleKeys.addAll(ruleKeys);
    }

    public void registerAutoScanCompatibleRules(Collection<RuleKey> ruleKeys) {
        this.autoScanCompatibleRules.addAll(ruleKeys);
    }

    private static void validateAndRegisterChecks(String repositoryKey, Collection<?> javaCheckClassesAndInstances, List<Class<? extends JavaCheck>> destCheckClasses, List<JavaCheck> destCheckInstances, List<RuleKey> destRuleKeys) {
        if (StringUtils.isBlank((CharSequence)repositoryKey)) {
            throw new IllegalArgumentException("Please specify a non blank repository key");
        }
        for (Object javaCheckClassOrInstance : javaCheckClassesAndInstances) {
            JavaCheck check;
            Class checkClass;
            try {
                if (javaCheckClassOrInstance instanceof Class) {
                    checkClass = (Class)javaCheckClassOrInstance;
                    check = (JavaCheck)checkClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else {
                    check = (JavaCheck)javaCheckClassOrInstance;
                    checkClass = check.getClass();
                }
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(String.format("Fail to instantiate %s", javaCheckClassOrInstance), e);
            }
            RuleKey ruleKey = RuleKey.of((String)repositoryKey, (String)RuleAnnotationUtils.getRuleKey((Class)checkClass));
            destCheckClasses.add(checkClass);
            destCheckInstances.add(check);
            destRuleKeys.add(ruleKey);
        }
    }
}

