/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier.internal;

import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.util.Collection;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.api.batch.sensor.cache.WriteCache;
import org.sonar.api.config.Configuration;
import org.sonar.java.SonarComponents;
import org.sonar.java.checks.verifier.internal.CacheEnabledSensorContext;
import org.sonar.java.checks.verifier.internal.InternalSensorContext;
import org.sonar.java.classpath.ClasspathForMain;
import org.sonar.java.classpath.ClasspathForTest;

public class CheckVerifierUtils {
    protected static final String CHECK_OR_CHECKS = "check(s)";
    protected static final String FILE_OR_FILES = "file(s)";

    private CheckVerifierUtils() {
    }

    protected static SonarComponents sonarComponents(final boolean isCacheEnabled, ReadCache readCache, WriteCache writeCache, final @Nullable File workingDirectory) {
        InternalSensorContext sensorContext = isCacheEnabled ? new CacheEnabledSensorContext(readCache, writeCache) : new InternalSensorContext();
        FileSystem fileSystem = sensorContext.fileSystem();
        Configuration config = sensorContext.config();
        ClasspathForMain classpathForMain = new ClasspathForMain(config, fileSystem);
        ClasspathForTest classpathForTest = new ClasspathForTest(config, fileSystem);
        SonarComponents sonarComponents = new SonarComponents(null, fileSystem, classpathForMain, classpathForTest, null, null){

            public boolean reportAnalysisError(RecognitionException re, InputFile inputFile) {
                throw new AssertionError((Object)String.format("Should not fail analysis (%s)", re.getMessage()));
            }

            public boolean canSkipUnchangedFiles() {
                return isCacheEnabled;
            }

            @Nullable
            public File projectLevelWorkDir() {
                return workingDirectory;
            }
        };
        sonarComponents.setSensorContext((SensorContext)sensorContext);
        return sonarComponents;
    }

    protected static void requiresNull(@Nullable Object obj, String fieldName) {
        if (obj != null) {
            throw new AssertionError((Object)String.format("Do not set %s multiple times!", fieldName));
        }
    }

    protected static void requiresNonNull(@Nullable Object obj, String fieldName) {
        if (obj == null) {
            throw new AssertionError((Object)String.format("Set %s before calling any verification method!", fieldName));
        }
    }

    protected static void requiresNonEmpty(Collection<?> objects, String fieldName) {
        if (objects.isEmpty()) {
            throw new AssertionError((Object)String.format("Provide at least one %s!", fieldName));
        }
    }
}

