/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.java.checks.verifier.internal.InternalMockedSonarAPI;
import org.sonar.java.checks.verifier.internal.InternalTextPointer;
import org.sonar.java.checks.verifier.internal.InternalTextRange;
import org.sonar.java.model.InputFileUtils;

public final class InternalInputFile
extends InternalMockedSonarAPI
implements InputFile {
    private final File file;
    private final String moduleKey;
    private final String contents;
    private final String md5;
    private final int numberLines;
    private final InputFile.Type type;
    private final InputFile.Status status;

    private InternalInputFile(String filename, InputFile.Type type) {
        this.file = new File(filename);
        this.moduleKey = "";
        this.contents = "";
        this.numberLines = -1;
        this.type = type;
        this.status = InputFile.Status.SAME;
        this.md5 = InputFileUtils.md5Hash((InputFile)this);
    }

    private InternalInputFile(String moduleKey, File file, InputFile.Status status) {
        this.file = file;
        this.moduleKey = moduleKey;
        this.contents = InternalInputFile.readFile(file);
        this.numberLines = this.contents.split("(\r)?\n|\r").length;
        this.type = InputFile.Type.MAIN;
        this.status = status;
        this.md5 = InputFileUtils.md5Hash((InputFile)this);
    }

    private static String readFile(File file) {
        try {
            return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to read file '%s'", file.getAbsolutePath()));
        }
    }

    public static InputFile inputFile(String moduleKey, File file) {
        return new InternalInputFile(moduleKey, file, InputFile.Status.SAME);
    }

    public static InputFile inputFile(String moduleKey, File file, InputFile.Status status) {
        return new InternalInputFile(moduleKey, file, status);
    }

    public static InputFile emptyInputFile(String filename, InputFile.Type type) {
        return new InternalInputFile(filename, type);
    }

    public String filename() {
        return this.file.getName();
    }

    public URI uri() {
        return this.file.toURI();
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public String key() {
        return this.moduleKey + ":" + this.path().toString().replace(File.separatorChar, '/');
    }

    public String absolutePath() {
        return this.file.getAbsolutePath();
    }

    public Charset charset() {
        return StandardCharsets.UTF_8;
    }

    public String contents() throws IOException {
        return this.contents;
    }

    public String md5Hash() {
        return this.md5;
    }

    public File file() {
        return this.file;
    }

    public InputStream inputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public String language() {
        return "java";
    }

    public int lines() {
        return this.numberLines;
    }

    public TextPointer newPointer(int line, int offset) {
        return new InternalTextPointer(line, offset);
    }

    public TextRange newRange(TextPointer start, TextPointer end) {
        return new InternalTextRange(start, end);
    }

    public TextRange newRange(int startLine, int startColumn, int endLine, int endColumn) {
        return new InternalTextRange(startLine, startColumn, endLine, endColumn);
    }

    public Path path() {
        return this.file.toPath();
    }

    public String relativePath() {
        return this.file.toPath().toString();
    }

    public InputFile.Type type() {
        return this.type;
    }

    public String toString() {
        return this.path().toString();
    }

    public TextRange selectLine(int arg0) {
        throw this.notSupportedException("selectLine(int)");
    }

    public InputFile.Status status() {
        return this.status;
    }
}

