/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier.internal;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.api.batch.sensor.cache.WriteCache;
import org.sonar.java.SonarComponents;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.ast.JavaAstScanner;
import org.sonar.java.ast.visitors.CommentLinesVisitor;
import org.sonar.java.caching.DummyCache;
import org.sonar.java.caching.JavaReadCacheImpl;
import org.sonar.java.caching.JavaWriteCacheImpl;
import org.sonar.java.checks.verifier.CheckVerifier;
import org.sonar.java.checks.verifier.internal.CheckVerifierUtils;
import org.sonar.java.checks.verifier.internal.InternalCacheContext;
import org.sonar.java.checks.verifier.internal.InternalInputFile;
import org.sonar.java.model.JavaVersionImpl;
import org.sonar.java.model.VisitorsBridge;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.test.classpath.TestClasspathUtils;
import org.sonar.java.testing.JavaFileScannerContextForTests;
import org.sonar.java.testing.VisitorsBridgeForTests;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.caching.CacheContext;
import org.sonar.plugins.java.api.caching.JavaReadCache;
import org.sonar.plugins.java.api.caching.JavaWriteCache;
import org.sonarsource.analyzer.commons.checks.verifier.MultiFileVerifier;
import org.sonarsource.analyzer.commons.checks.verifier.quickfix.QuickFix;
import org.sonarsource.analyzer.commons.checks.verifier.quickfix.TextEdit;
import org.sonarsource.analyzer.commons.checks.verifier.quickfix.TextSpan;

public class JavaCheckVerifier
implements CheckVerifier {
    private static final JavaVersion DEFAULT_JAVA_VERSION = new JavaVersionImpl();
    private static final List<File> DEFAULT_CLASSPATH;
    private static final int COMMENT_PREFIX_LENGTH = 2;
    private static final int COMMENT_SUFFIX_LENGTH = 0;
    private List<JavaFileScanner> checks = null;
    private List<File> classpath = null;
    private JavaVersion javaVersion = null;
    private boolean inAndroidContext = false;
    private List<InputFile> files = null;
    private boolean withoutSemantic = false;
    private boolean isCacheEnabled = false;
    @VisibleForTesting
    CacheContext cacheContext = null;
    private ReadCache readCache;
    private WriteCache writeCache;
    private File rootDirectory;

    private JavaCheckVerifier() {
    }

    public static JavaCheckVerifier newInstance() {
        return new JavaCheckVerifier();
    }

    private MultiFileVerifier createVerifier() {
        MultiFileVerifier verifier = MultiFileVerifier.create((Path)Paths.get(this.files.get(0).uri()), (Charset)StandardCharsets.UTF_8);
        JavaVersion actualVersion = this.javaVersion == null ? DEFAULT_JAVA_VERSION : this.javaVersion;
        List<File> actualClasspath = this.classpath == null ? DEFAULT_CLASSPATH : this.classpath;
        ArrayList<JavaFileScanner> visitors = new ArrayList<JavaFileScanner>(this.checks);
        CommentLinesVisitor commentLinesVisitor = new CommentLinesVisitor();
        visitors.add((JavaFileScanner)commentLinesVisitor);
        SonarComponents sonarComponents = CheckVerifierUtils.sonarComponents(this.isCacheEnabled, this.readCache, this.writeCache, this.rootDirectory);
        VisitorsBridgeForTests visitorsBridge = this.withoutSemantic ? new VisitorsBridgeForTests(visitors, sonarComponents, actualVersion) : new VisitorsBridgeForTests(visitors, actualClasspath, sonarComponents, actualVersion);
        JavaAstScanner astScanner = new JavaAstScanner(sonarComponents);
        visitorsBridge.setInAndroidContext(this.inAndroidContext);
        astScanner.setVisitorBridge((VisitorsBridge)visitorsBridge);
        List filesToParse = this.files;
        if (this.isCacheEnabled) {
            visitorsBridge.setCacheContext(this.cacheContext);
            filesToParse = (List)astScanner.scanWithoutParsing(this.files).get(false);
        }
        astScanner.scan(filesToParse);
        JavaCheckVerifier.addComments(verifier, commentLinesVisitor);
        JavaFileScannerContextForTests testJavaFileScannerContext = visitorsBridge.lastCreatedTestContext();
        JavaFileScannerContextForTests testModuleScannerContext = visitorsBridge.lastCreatedModuleContext();
        if (testJavaFileScannerContext != null) {
            JavaCheckVerifier.addIssues(testJavaFileScannerContext, verifier);
            JavaCheckVerifier.addIssues(testModuleScannerContext, verifier);
        }
        return verifier;
    }

    private static void addIssues(JavaFileScannerContextForTests scannerContext, MultiFileVerifier verifier) {
        scannerContext.getIssues().forEach(issue -> {
            if (!issue.getInputComponent().isFile()) {
                return;
            }
            Path path = ((InternalInputFile)issue.getInputComponent()).path();
            String issueMessage = issue.getMessage();
            AnalyzerMessage.TextSpan textSpan = issue.primaryLocation();
            MultiFileVerifier.Issue verifierIssue = textSpan != null ? JavaCheckVerifier.getIssueForTextSpan(verifier, textSpan, path, issueMessage) : (issue.getLine() != null ? verifier.reportIssue(path, issueMessage).onLine(issue.getLine().intValue()) : verifier.reportIssue(path, issueMessage).onFile());
            List quickfixes = (List)scannerContext.getQuickFixes().get(textSpan);
            if (quickfixes != null) {
                for (JavaQuickFix qf : quickfixes) {
                    verifierIssue = verifierIssue.addQuickFix(JavaCheckVerifier.convertQuickFix(qf));
                }
            }
            List<AnalyzerMessage> secondaries = issue.flows.stream().map(l -> l.isEmpty() ? null : (AnalyzerMessage)l.get(0)).filter(Objects::nonNull).toList();
            MultiFileVerifier.Issue finalVerifierIssue = verifierIssue;
            secondaries.forEach(secondary -> JavaCheckVerifier.addSecondary(path, finalVerifierIssue, secondary));
        });
    }

    private static MultiFileVerifier.Issue getIssueForTextSpan(MultiFileVerifier verifier, AnalyzerMessage.TextSpan textSpan, Path path, String issueMessage) {
        MultiFileVerifier.Issue verifierIssue = textSpan.endCharacter < 0 ? verifier.reportIssue(path, issueMessage).onLine(textSpan.startLine) : verifier.reportIssue(path, issueMessage).onRange(textSpan.startLine, textSpan.startCharacter + 1, textSpan.endLine, textSpan.endCharacter);
        return verifierIssue;
    }

    private static QuickFix convertQuickFix(JavaQuickFix javaQuickFix) {
        return QuickFix.newQuickFix((String)javaQuickFix.getDescription()).addTextEdits(javaQuickFix.getTextEdits().stream().map(te -> TextEdit.replaceTextSpan((TextSpan)JavaCheckVerifier.convertTextSpan(te.getTextSpan()), (String)JavaCheckVerifier.convertReplacement(te.getReplacement()))).toList()).build();
    }

    private static TextSpan convertTextSpan(AnalyzerMessage.TextSpan textSpan) {
        return new TextSpan(textSpan.startLine, textSpan.startCharacter + 1, textSpan.endLine, textSpan.endCharacter + 1);
    }

    private static String convertReplacement(String replacement) {
        return replacement.replace("\n", "\\n");
    }

    private static void addSecondary(Path path, MultiFileVerifier.Issue issue, AnalyzerMessage secondary) {
        AnalyzerMessage.TextSpan textSpan = secondary.primaryLocation();
        issue.addSecondary(path, textSpan.startLine, textSpan.startCharacter + 1, textSpan.endLine, textSpan.endCharacter, secondary.getMessage());
    }

    private static void addComments(MultiFileVerifier singleFileVerifier, CommentLinesVisitor commentLinesVisitor) {
        commentLinesVisitor.getSyntaxTrivia().keySet().forEach(path -> ((Set)commentLinesVisitor.getSyntaxTrivia().get(path)).stream().sorted(Comparator.comparingInt(t -> t.range().start().line())).forEach(trivia -> singleFileVerifier.addComment(path, trivia.range().start().line(), trivia.range().start().column(), trivia.comment(), 2, 0)));
    }

    @Override
    public CheckVerifier withCheck(JavaFileScanner check) {
        CheckVerifierUtils.requiresNull(this.checks, "check(s)");
        this.checks = Collections.singletonList(check);
        return this;
    }

    @Override
    public CheckVerifier withChecks(JavaFileScanner ... checks) {
        CheckVerifierUtils.requiresNull(this.checks, "check(s)");
        CheckVerifierUtils.requiresNonEmpty(Arrays.asList(checks), "check");
        this.checks = Arrays.asList(checks);
        return this;
    }

    @Override
    public CheckVerifier withClassPath(Collection<File> classpath) {
        CheckVerifierUtils.requiresNull(this.classpath, "classpath");
        this.classpath = new ArrayList<File>(classpath);
        return this;
    }

    @Override
    public CheckVerifier withJavaVersion(int javaVersionAsInt) {
        CheckVerifierUtils.requiresNull(this.javaVersion, "java version");
        return this.withJavaVersion(javaVersionAsInt, false);
    }

    @Override
    public CheckVerifier withJavaVersion(int javaVersionAsInt, boolean enablePreviewFeatures) {
        CheckVerifierUtils.requiresNull(this.javaVersion, "java version");
        if (enablePreviewFeatures && javaVersionAsInt != 22) {
            String message = String.format("Preview features can only be enabled when the version == latest supported Java version (%d != %d)", javaVersionAsInt, 22);
            throw new IllegalArgumentException(message);
        }
        this.javaVersion = new JavaVersionImpl(javaVersionAsInt, enablePreviewFeatures);
        return this;
    }

    @Override
    public CheckVerifier withinAndroidContext(boolean inAndroidContext) {
        this.inAndroidContext = inAndroidContext;
        return this;
    }

    @Override
    public CheckVerifier onFile(String filename) {
        CheckVerifierUtils.requiresNull(this.files, "file(s)");
        return this.onFiles(Collections.singletonList(filename));
    }

    @Override
    public CheckVerifier onFiles(String ... filenames) {
        List<String> asList = Arrays.asList(filenames);
        CheckVerifierUtils.requiresNonEmpty(asList, "file");
        return this.onFiles(asList);
    }

    @Override
    public CheckVerifier onFiles(Collection<String> filenames) {
        CheckVerifierUtils.requiresNull(this.files, "file(s)");
        CheckVerifierUtils.requiresNonEmpty(filenames, "file");
        this.files = new ArrayList<InputFile>();
        return this.addFiles(InputFile.Status.SAME, filenames);
    }

    @Override
    public CheckVerifier addFiles(InputFile.Status status, String ... filenames) {
        return this.addFiles(status, Arrays.asList(filenames));
    }

    @Override
    public CheckVerifier addFiles(InputFile.Status status, Collection<String> filenames) {
        CheckVerifierUtils.requiresNonEmpty(filenames, "file");
        if (this.files == null) {
            this.files = new ArrayList<InputFile>(filenames.size());
        }
        List<InputFile> filesToAdd = filenames.stream().map(name -> InternalInputFile.inputFile("", new File((String)name), status)).toList();
        List<String> filesToAddStrings = filesToAdd.stream().map(Object::toString).toList();
        this.files.forEach(inputFile -> {
            if (filesToAddStrings.contains(inputFile.toString())) {
                throw new IllegalArgumentException(String.format("File %s was already added.", inputFile));
            }
        });
        this.files.addAll(filesToAdd);
        return this;
    }

    @Override
    public CheckVerifier withoutSemantic() {
        this.withoutSemantic = true;
        return this;
    }

    @Override
    public CheckVerifier withCache(@Nullable ReadCache readCache, @Nullable WriteCache writeCache) {
        this.isCacheEnabled = true;
        this.readCache = readCache;
        this.writeCache = writeCache;
        this.cacheContext = new InternalCacheContext(true, (JavaReadCache)(readCache == null ? new DummyCache() : new JavaReadCacheImpl(readCache)), (JavaWriteCache)(writeCache == null ? new DummyCache() : new JavaWriteCacheImpl(writeCache)));
        return this;
    }

    @Override
    public CheckVerifier withProjectLevelWorkDir(String rootDirectory) {
        this.rootDirectory = new File(rootDirectory);
        return this;
    }

    @Override
    public void verifyIssues() {
        CheckVerifierUtils.requiresNonNull(this.checks, "check(s)");
        CheckVerifierUtils.requiresNonNull(this.files, "file(s)");
        this.createVerifier().assertOneOrMoreIssues();
    }

    @Override
    public void verifyIssueOnFile(String expectedIssueMessage) {
        CheckVerifierUtils.requiresNonNull(this.checks, "check(s)");
        CheckVerifierUtils.requiresNonNull(this.files, "file(s)");
        this.createVerifier().assertOneOrMoreIssues();
    }

    @Override
    public void verifyIssueOnProject(String expectedIssueMessage) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public void verifyNoIssues() {
        CheckVerifierUtils.requiresNonNull(this.checks, "check(s)");
        CheckVerifierUtils.requiresNonNull(this.files, "file(s)");
        this.createVerifier().assertNoIssuesRaised();
    }

    static {
        Path path = Paths.get("../java-checks-test-sources/default/target/test-classpath.txt".replace('/', File.separatorChar), new String[0]);
        DEFAULT_CLASSPATH = Files.exists(path, new LinkOption[0]) ? TestClasspathUtils.loadFromFile((String)path.toString()) : new ArrayList();
        Optional.of(new File("../java-checks-test-sources/default/target/classes")).filter(File::exists).ifPresent(DEFAULT_CLASSPATH::add);
    }
}

