/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.api.batch.sensor.cache.WriteCache;

public class InternalWriteCache
implements WriteCache {
    private final Map<String, byte[]> data = new HashMap<String, byte[]>();
    private ReadCache readCache;

    public InternalWriteCache bind(ReadCache readCache) {
        this.readCache = readCache;
        return this;
    }

    public Map<String, byte[]> getData() {
        return this.data;
    }

    public void write(String key, InputStream data) {
        try {
            this.write(key, data.readAllBytes());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read stream", e);
        }
    }

    public void write(String key, byte[] data) {
        if (this.data.containsKey(key)) {
            throw new IllegalArgumentException(String.format("Same key cannot be written to multiple times (%s)", key));
        }
        this.data.put(key, data);
    }

    public void copyFromPrevious(String key) {
        this.write(key, this.readCache.read(key));
    }
}

