/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S5122")
public class CORSCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatcher SET_HEADER_MATCHER = MethodMatcher.create().typeDefinition("javax.servlet.http.HttpServletResponse").name("setHeader").withAnyParameters();
    private static final Set<String> HTTP_HEADERS = new HashSet<String>(Arrays.asList("Access-Control-Allow-Origin", "Access-Control-Allow-Credentials", "Access-Control-Expose-Headers", "Access-Control-Max-Age", "Access-Control-Allow-Methods", "Access-Control-Allow-Headers"));
    private static final MethodMatcher ADD_ALLOWED_ORIGIN = MethodMatcher.create().typeDefinition("org.springframework.web.cors.CorsConfiguration").name("addAllowedOrigin").withAnyParameters();
    private static final MethodMatcher APPLY_PERMIT_DEFAULT_VALUES = MethodMatcher.create().typeDefinition("org.springframework.web.cors.CorsConfiguration").name("applyPermitDefaultValues").withAnyParameters();
    public static final String MESSAGE = "Make sure that enabling CORS is safe here.";

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.ANNOTATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.checkMethod(tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.ANNOTATION}) && ((AnnotationTree)tree).symbolType().is("org.springframework.web.bind.annotation.CrossOrigin")) {
            this.reportTree((Tree)((AnnotationTree)tree).annotationType());
        }
    }

    private void checkMethod(Tree tree) {
        MethodInvocationVisitor visitor = new MethodInvocationVisitor();
        tree.accept((TreeVisitor)visitor);
        if (!visitor.addAllowedOrigin.isEmpty() && !visitor.applyPermit.isEmpty()) {
            visitor.addAllowedOrigin.forEach(mit -> {
                List locations = visitor.applyPermit.stream().map(t -> new JavaFileScannerContext.Location(MESSAGE, (Tree)t)).collect(Collectors.toList());
                this.reportIssue((Tree)mit.methodSelect(), MESSAGE, locations, null);
            });
        } else {
            visitor.addAllowedOrigin.forEach(this::reportTree);
            visitor.applyPermit.forEach(this::reportTree);
        }
    }

    private void reportTree(Tree tree) {
        this.reportIssue(tree, MESSAGE);
    }

    private class MethodInvocationVisitor
    extends BaseTreeVisitor {
        List<MethodInvocationTree> addAllowedOrigin = new ArrayList<MethodInvocationTree>();
        List<MethodInvocationTree> applyPermit = new ArrayList<MethodInvocationTree>();

        private MethodInvocationVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree mit) {
            if (SET_HEADER_MATCHER.matches(mit)) {
                String constantCORS = ExpressionsHelper.getConstantValueAsString((ExpressionTree)mit.arguments().get(0)).value();
                if (HTTP_HEADERS.contains(constantCORS)) {
                    CORSCheck.this.reportTree((Tree)mit.methodSelect());
                }
            } else if (APPLY_PERMIT_DEFAULT_VALUES.matches(mit)) {
                this.applyPermit.add(mit);
            } else if (ADD_ALLOWED_ORIGIN.matches(mit)) {
                this.addAllowedOrigin.add(mit);
            }
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

