/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3972")
public class ConditionalOnNewLineCheck
extends IssuableSubscriptionVisitor {
    private SyntaxToken previousToken;

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.IF_STATEMENT);
    }

    public void setContext(JavaFileScannerContext context) {
        this.previousToken = null;
        super.setContext(context);
    }

    public void visitNode(Tree tree) {
        IfStatementTree ifStatementTree = (IfStatementTree)tree;
        SyntaxToken lastToken = ifStatementTree.thenStatement().lastToken();
        if (ifStatementTree.elseKeyword() == null) {
            if (this.previousToken != null && this.isOnSameLineAsPreviousIf(ifStatementTree)) {
                this.reportIssue((Tree)ifStatementTree.ifKeyword(), "Move this \"if\" to a new line or add the missing \"else\".", Collections.singletonList(new JavaFileScannerContext.Location("", (Tree)this.previousToken)), null);
            }
            this.previousToken = lastToken;
        }
    }

    private boolean isOnSameLineAsPreviousIf(IfStatementTree ifStatementTree) {
        return this.previousToken.line() == ifStatementTree.ifKeyword().line() && this.previousToken.column() < ifStatementTree.ifKeyword().column();
    }
}

