/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2142")
public class InterruptedExceptionCheck
extends IssuableSubscriptionVisitor {
    private static final Predicate<Type> INTERRUPTING_TYPE_PREDICATE = catchType -> catchType.is("java.lang.InterruptedException") || catchType.is("java.lang.ThreadDeath");
    private Deque<Boolean> withinInterruptingFinally = new LinkedList<Boolean>();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TRY_STATEMENT);
    }

    public void leaveFile(JavaFileScannerContext context) {
        this.withinInterruptingFinally.clear();
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        TryStatementTree tryStatementTree = (TryStatementTree)tree;
        this.withinInterruptingFinally.addFirst(InterruptedExceptionCheck.isFinallyInterrupting(tryStatementTree.finallyBlock()));
        for (CatchTree catchTree : tryStatementTree.catches()) {
            Optional<Type> interruptType = InterruptedExceptionCheck.findInterruptingType(catchTree.parameter());
            if (!interruptType.isPresent()) continue;
            BlockVisitor blockVisitor = new BlockVisitor(catchTree.parameter().symbol());
            catchTree.block().accept((TreeVisitor)blockVisitor);
            if (blockVisitor.threadInterrupted || this.isWithinInterruptingFinally()) continue;
            this.reportIssue((Tree)catchTree.parameter(), "Either re-interrupt this method or rethrow the \"" + interruptType.get().name() + "\".");
        }
    }

    private static Optional<Type> findInterruptingType(VariableTree parameter) {
        if (parameter.type().is(new Tree.Kind[]{Tree.Kind.UNION_TYPE})) {
            return ((UnionTypeTree)parameter.type()).typeAlternatives().stream().map(TypeTree::symbolType).filter(INTERRUPTING_TYPE_PREDICATE).findFirst();
        }
        return Optional.of(parameter).map(VariableTree::symbol).map(Symbol::type).filter(INTERRUPTING_TYPE_PREDICATE);
    }

    private boolean isWithinInterruptingFinally() {
        for (Boolean aBoolean : this.withinInterruptingFinally) {
            if (!aBoolean.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void leaveNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        this.withinInterruptingFinally.removeFirst();
    }

    private static boolean isFinallyInterrupting(@Nullable BlockTree blockTree) {
        if (blockTree == null) {
            return false;
        }
        BlockVisitor blockVisitor = new BlockVisitor();
        blockTree.accept((TreeVisitor)blockVisitor);
        return blockVisitor.threadInterrupted;
    }

    private static class BlockVisitor
    extends BaseTreeVisitor {
        @Nullable
        private final Symbol catchedException;
        boolean threadInterrupted = false;

        public BlockVisitor() {
            this.catchedException = null;
        }

        public BlockVisitor(Symbol catchedException) {
            this.catchedException = catchedException;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            Symbol symbol = tree.symbol();
            if (!symbol.isUnknown() && symbol.owner().type().isSubtypeOf("java.lang.Thread") && "interrupt".equals(symbol.name()) && tree.arguments().isEmpty()) {
                this.threadInterrupted = true;
                return;
            }
            super.visitMethodInvocation(tree);
        }

        public void visitThrowStatement(ThrowStatementTree tree) {
            if (tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && ((IdentifierTree)tree.expression()).symbol().equals(this.catchedException)) {
                this.threadInterrupted = true;
                return;
            }
            super.visitThrowStatement(tree);
        }
    }
}

