/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractPrintfChecker;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2275")
public class PrintfFailCheck
extends AbstractPrintfChecker {
    private static final Set<String> TIME_CONVERSIONS = Sets.newHashSet((Object[])new String[]{"H", "I", "k", "l", "M", "S", "L", "N", "p", "z", "Z", "s", "Q", "B", "b", "h", "A", "a", "C", "Y", "y", "j", "m", "d", "e", "R", "T", "r", "D", "F", "c"});

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        boolean isMessageFormat = MESSAGE_FORMAT.matches(mit);
        if (isMessageFormat && !mit.symbol().isStatic()) {
            return;
        }
        if (!isMessageFormat && (isMessageFormat = JAVA_UTIL_LOGGER.matches(mit)) && ((ExpressionTree)mit.arguments().get(2)).symbolType().isSubtypeOf("java.lang.Throwable")) {
            return;
        }
        if (!isMessageFormat && (isMessageFormat = LEVELS.contains(mit.symbol().name())) && ((ExpressionTree)mit.arguments().get(mit.arguments().size() - 1)).symbolType().isSubtypeOf("java.lang.Throwable")) {
            return;
        }
        this.checkFormatting(mit, isMessageFormat);
    }

    private void checkFormatting(MethodInvocationTree mit, boolean isMessageFormat) {
        List args;
        ExpressionTree formatStringTree;
        if (mit.arguments().stream().map(ExpressionTree::symbolType).anyMatch(Type::isUnknown)) {
            return;
        }
        if (((ExpressionTree)mit.arguments().get(0)).symbolType().is("java.lang.String")) {
            formatStringTree = (ExpressionTree)mit.arguments().get(0);
            args = mit.arguments().subList(1, mit.arguments().size());
        } else {
            formatStringTree = (ExpressionTree)mit.arguments().get(1);
            args = mit.arguments().subList(2, mit.arguments().size());
        }
        if (formatStringTree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            String formatString = LiteralUtils.trimQuotes((String)((LiteralTree)formatStringTree).value());
            if (isMessageFormat) {
                this.handleMessageFormat(mit, formatString, args);
            } else {
                this.handlePrintfFormat(mit, formatString, args);
            }
        }
    }

    @Override
    protected void handlePrintfFormat(MethodInvocationTree mit, String formatString, List<ExpressionTree> args) {
        List<String> params = this.getParameters(formatString, mit);
        PrintfFailCheck.cleanupLineSeparator(params);
        if (!params.isEmpty()) {
            if (this.checkArgumentNumber(mit, PrintfFailCheck.argIndexes(params).size(), args.size())) {
                return;
            }
            this.verifyParameters(mit, args, params);
        }
    }

    @Override
    protected void handleMessageFormat(MethodInvocationTree mit, String formatString, List<ExpressionTree> args) {
        ExpressionTree firstArg;
        String newFormatString = PrintfFailCheck.cleanupDoubleQuote(formatString);
        Set<Integer> indexes = PrintfFailCheck.getMessageFormatIndexes(newFormatString, mit);
        ListTree newArgs = args;
        if (newArgs.size() == 1 && (firstArg = newArgs.get(0)).symbolType().isArray()) {
            if (PrintfFailCheck.isNewArrayWithInitializers(firstArg)) {
                newArgs = ((NewArrayTree)firstArg).initializers();
            } else {
                return;
            }
        }
        if (this.checkArgumentNumber(mit, indexes.size(), newArgs.size()) || this.checkUnbalancedQuotes(mit, newFormatString) || this.checkUnbalancedBraces(mit, newFormatString)) {
            return;
        }
        this.verifyParameters(mit, (List<ExpressionTree>)newArgs, indexes);
    }

    private boolean checkArgumentNumber(MethodInvocationTree mit, int nbReadParams, int nbArgs) {
        if (nbReadParams > nbArgs) {
            this.reportIssue((Tree)mit, "Not enough arguments.");
            return true;
        }
        return false;
    }

    private boolean checkUnbalancedQuotes(MethodInvocationTree mit, String formatString) {
        boolean unbalancedQuotes;
        if (LEVELS.contains(mit.symbol().name())) {
            return false;
        }
        String withoutParam = MESSAGE_FORMAT_PATTERN.matcher(formatString).replaceAll("");
        int numberQuote = 0;
        for (int i = 0; i < withoutParam.length(); ++i) {
            if (withoutParam.charAt(i) != '\'') continue;
            ++numberQuote;
        }
        boolean bl = unbalancedQuotes = numberQuote % 2 != 0;
        if (unbalancedQuotes) {
            this.reportIssue((Tree)mit.arguments().get(0), "Single quote \"'\" must be escaped.");
        }
        return unbalancedQuotes;
    }

    private boolean checkUnbalancedBraces(MethodInvocationTree mit, String formatString) {
        boolean unbalancedBraces;
        String withoutParam = MESSAGE_FORMAT_PATTERN.matcher(formatString).replaceAll("");
        int numberOpenBrace = 0;
        block4: for (int i = 0; i < withoutParam.length(); ++i) {
            char ch = withoutParam.charAt(i);
            switch (ch) {
                case '{': {
                    ++numberOpenBrace;
                    continue block4;
                }
                case '}': {
                    --numberOpenBrace;
                    continue block4;
                }
            }
        }
        boolean bl = unbalancedBraces = numberOpenBrace > 0;
        if (unbalancedBraces) {
            this.reportIssue((Tree)mit.arguments().get(0), "Single left curly braces \"{\" must be escaped.");
        }
        return unbalancedBraces;
    }

    private void verifyParameters(MethodInvocationTree mit, List<ExpressionTree> args, Set<Integer> indexes) {
        for (int index : indexes) {
            if (index < args.size()) continue;
            this.reportIssue((Tree)mit, "Not enough arguments.");
            return;
        }
    }

    private void verifyParameters(MethodInvocationTree mit, List<ExpressionTree> args, List<String> params) {
        int index = 0;
        Iterator<String> iterator = params.iterator();
        while (iterator.hasNext()) {
            String rawParam;
            String param = rawParam = iterator.next();
            int argIndex = index++;
            if (param.contains("$")) {
                argIndex = PrintfFailCheck.getIndex(param) - 1;
                if (argIndex == -1) {
                    this.reportIssue((Tree)mit, "Arguments are numbered starting from 1.");
                    return;
                }
                param = param.substring(param.indexOf(36) + 1);
            } else if (param.charAt(0) == '<') {
                argIndex = Math.max(0, argIndex - 1);
            }
            if (argIndex >= args.size()) {
                int formatIndex = argIndex + 1;
                this.reportIssue((Tree)mit, "Not enough arguments to feed formater at index " + formatIndex + ": '%" + formatIndex + "$'.");
                return;
            }
            ExpressionTree argExpressionTree = args.get(argIndex);
            Type argType = argExpressionTree.symbolType();
            this.checkNumerical(mit, param, argType);
            this.checkTimeConversion(mit, param, argType);
        }
    }

    @Override
    protected void reportMissingPrevious(MethodInvocationTree mit) {
        this.reportIssue((Tree)mit, "The argument index '<' refers to the previous format specifier but there isn't one.");
    }

    private void checkNumerical(MethodInvocationTree mit, String param, Type argType) {
        if (param.charAt(0) == 'd' && !PrintfFailCheck.isNumerical(argType)) {
            this.reportIssue((Tree)mit, "An 'int' is expected rather than a " + argType + ".");
        }
    }

    private void checkTimeConversion(MethodInvocationTree mit, String param, Type argType) {
        if (param.charAt(0) == 't' || param.charAt(0) == 'T') {
            String timeConversion = param.substring(1);
            if (timeConversion.isEmpty()) {
                this.reportIssue((Tree)mit, "Time conversion requires a second character.");
                this.checkTimeTypeArgument(mit, argType);
                return;
            }
            if (!TIME_CONVERSIONS.contains(timeConversion)) {
                this.reportIssue((Tree)mit, timeConversion + " is not a supported time conversion character");
            }
            this.checkTimeTypeArgument(mit, argType);
        }
    }

    private void checkTimeTypeArgument(MethodInvocationTree mit, Type argType) {
        if (!(argType.isNumerical() || argType.is("java.lang.Long") || PrintfFailCheck.isSubtypeOfAny(argType, "java.util.Date", "java.util.Calendar", "java.time.temporal.TemporalAccessor"))) {
            this.reportIssue((Tree)mit, "Time argument is expected (long, Long, Calendar, Date and TemporalAccessor).");
        }
    }

    private static boolean isNumerical(Type argType) {
        return argType.isNumerical() || PrintfFailCheck.isTypeOfAny(argType, "java.math.BigInteger", "java.math.BigDecimal", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double");
    }

    private static boolean isTypeOfAny(Type argType, String ... fullyQualifiedNames) {
        return Arrays.stream(fullyQualifiedNames).anyMatch(arg_0 -> ((Type)argType).is(arg_0));
    }

    private static boolean isSubtypeOfAny(Type argType, String ... fullyQualifiedNames) {
        return Arrays.stream(fullyQualifiedNames).anyMatch(arg_0 -> ((Type)argType).isSubtypeOf(arg_0));
    }
}

