/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4425")
public class IntegerToHexStringCheck
extends AbstractMethodDetection {
    private static final MethodMatcher APPEND_MATCHER = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.lang.AbstractStringBuilder")).name("append").addParameter(TypeCriteria.is((String)"java.lang.String"));
    private static final MethodMatcher PRINT_MATCHER = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.io.PrintStream")).name("print").addParameter(TypeCriteria.is((String)"java.lang.String"));
    private static final MethodMatcher JOINER_MATCHER = MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.util.StringJoiner")).name("add").addParameter(TypeCriteria.is((String)"java.lang.CharSequence"));

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Collections.singletonList(MethodMatcher.create().typeDefinition(TypeCriteria.is((String)"java.lang.Integer")).name("toHexString").addParameter(TypeCriteria.is((String)"int")));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree method) {
        if (IntegerToHexStringCheck.isArgumentAppended(method) && IntegerToHexStringCheck.typeIsByte((ExpressionTree)method.arguments().get(0))) {
            this.reportIssue((Tree)method.methodSelect(), "Use String.format( \"%02X\", ...) instead.");
        }
    }

    private static boolean isArgumentAppended(MethodInvocationTree method) {
        return Optional.of(method).map(Tree::parent).filter(tree -> tree.is(new Tree.Kind[]{Tree.Kind.ARGUMENTS})).map(Tree::parent).filter(tree -> tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})).map(MethodInvocationTree.class::cast).filter(parentMethod -> APPEND_MATCHER.matches(parentMethod) || PRINT_MATCHER.matches(parentMethod) || JOINER_MATCHER.matches(parentMethod)).isPresent();
    }

    private static boolean typeIsByte(ExpressionTree expression) {
        return expression.symbolType().isSubtypeOf("byte") || ExpressionUtils.isSecuringByte((ExpressionTree)expression);
    }
}

