/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2092")
public class SecureCookieCheck
extends IssuableSubscriptionVisitor {
    private static final String MESSAGE = "Make sure creating this cookie without the \"secure\" flag is safe here.";
    private static final String JAX_RS_COOKIE = "javax.ws.rs.core.Cookie";
    private static final String JAX_RS_NEW_COOKIE = "javax.ws.rs.core.NewCookie";
    private static final String SPRING_SAVED_COOKIE = "org.springframework.security.web.savedrequest.SavedCookie";
    private static final String PLAY_COOKIE = "play.mvc.Http$Cookie";
    private static final List<String> COOKIES = Arrays.asList("javax.servlet.http.Cookie", "java.net.HttpCookie", "javax.ws.rs.core.Cookie", "javax.ws.rs.core.NewCookie", "org.apache.shiro.web.servlet.SimpleCookie", "org.springframework.security.web.savedrequest.SavedCookie", "play.mvc.Http$Cookie", "play.mvc.Http$CookieBuilder");
    private static final List<String> SETTER_NAMES = Arrays.asList("setSecure", "withSecure");
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String INT = "int";
    private static final String BOOLEAN = "boolean";
    private static final List<MethodMatcher> CONSTRUCTORS_WITH_SECURE_PARAM_LAST = Arrays.asList(SecureCookieCheck.constructorMatcher("javax.ws.rs.core.NewCookie").parameters(new String[]{"javax.ws.rs.core.Cookie", "java.lang.String", "int", "boolean"}), SecureCookieCheck.constructorMatcher("javax.ws.rs.core.NewCookie").parameters(new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "int", "java.lang.String", "int", "boolean"}), SecureCookieCheck.constructorMatcher("javax.ws.rs.core.NewCookie").parameters(new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "int", "boolean"}));
    private static final List<MethodMatcher> CONSTRUCTORS_WITH_SECURE_PARAM_BEFORE_LAST = Arrays.asList(SecureCookieCheck.constructorMatcher("javax.ws.rs.core.NewCookie").parameters(new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "int", "java.lang.String", "int", "java.util.Date", "boolean", "boolean"}), SecureCookieCheck.constructorMatcher("javax.ws.rs.core.NewCookie").parameters(new String[]{"javax.ws.rs.core.Cookie", "java.lang.String", "int", "java.util.Date", "boolean", "boolean"}), SecureCookieCheck.constructorMatcher("javax.ws.rs.core.NewCookie").parameters(new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "int", "boolean", "boolean"}), SecureCookieCheck.constructorMatcher("org.springframework.security.web.savedrequest.SavedCookie").parameters(new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "int", "java.lang.String", "boolean", "int"}), SecureCookieCheck.constructorMatcher("play.mvc.Http$Cookie").parameters(new String[]{"java.lang.String", "java.lang.String", "java.lang.Integer", "java.lang.String", "java.lang.String", "boolean", "boolean"}));
    private static final List<MethodMatcher> CONSTRUCTORS_WITH_SECURE_PARAM_BEFORE_BEFORE_LAST = Collections.singletonList(SecureCookieCheck.constructorMatcher("play.mvc.Http$Cookie").parameters(new String[]{"java.lang.String", "java.lang.String", "java.lang.Integer", "java.lang.String", "java.lang.String", "boolean", "boolean", "play.mvc.Http$Cookie$SameSite"}));
    private final Map<Symbol.VariableSymbol, NewClassTree> unsecuredCookies = new HashMap<Symbol.VariableSymbol, NewClassTree>();
    private final Set<NewClassTree> cookieConstructors = new HashSet<NewClassTree>();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.VARIABLE, Tree.Kind.ASSIGNMENT, Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    public void setContext(JavaFileScannerContext context) {
        this.unsecuredCookies.clear();
        this.cookieConstructors.clear();
        super.setContext(context);
    }

    public void leaveFile(JavaFileScannerContext context) {
        this.cookieConstructors.forEach(r -> this.reportIssue((Tree)r.identifier(), MESSAGE));
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            this.addToUnsecuredCookies((VariableTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            this.addToUnsecuredCookies((AssignmentExpressionTree)tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            this.checkSecureCall((MethodInvocationTree)tree);
        } else {
            this.checkConstructor((NewClassTree)tree);
        }
    }

    private void addToUnsecuredCookies(VariableTree variableTree) {
        ExpressionTree initializer = variableTree.initializer();
        Symbol variableTreeSymbol = variableTree.symbol();
        if (initializer != null && variableTreeSymbol.isVariableSymbol()) {
            boolean isMatchedType;
            boolean isInitializedWithConstructor = initializer.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS});
            boolean bl = isMatchedType = SecureCookieCheck.isCookieClass(variableTreeSymbol.type()) || SecureCookieCheck.isCookieClass(initializer.symbolType());
            if (isInitializedWithConstructor && isMatchedType && SecureCookieCheck.isSecureParamFalse((NewClassTree)initializer)) {
                this.unsecuredCookies.put((Symbol.VariableSymbol)variableTreeSymbol, (NewClassTree)initializer);
            }
        }
    }

    private void addToUnsecuredCookies(AssignmentExpressionTree assignment) {
        if (assignment.expression().is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && assignment.variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            boolean isMatchedType;
            IdentifierTree assignmentVariable = (IdentifierTree)assignment.variable();
            Symbol assignmentVariableSymbol = assignmentVariable.symbol();
            boolean bl = isMatchedType = SecureCookieCheck.isCookieClass(assignmentVariable.symbolType()) || SecureCookieCheck.isCookieClass(assignment.expression().symbolType());
            if (isMatchedType && SecureCookieCheck.isSecureParamFalse((NewClassTree)assignment.expression())) {
                this.unsecuredCookies.put((Symbol.VariableSymbol)assignmentVariableSymbol, (NewClassTree)assignment.expression());
            }
        }
    }

    private void checkSecureCall(MethodInvocationTree mit) {
        if (SecureCookieCheck.isSetSecureCall(mit) && mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree methodObject;
            boolean isFalse;
            ExpressionsHelper.ValueResolution<Boolean> valueResolution = ExpressionsHelper.getConstantValueAsBoolean((ExpressionTree)mit.arguments().get(0));
            Boolean secureArgument = valueResolution.value();
            boolean bl = isFalse = secureArgument != null && secureArgument == false;
            if (isFalse) {
                this.reportIssue((Tree)mit.arguments(), MESSAGE, valueResolution.valuePath(), null);
            }
            if ((methodObject = ((MemberSelectExpressionTree)mit.methodSelect()).expression()).is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                IdentifierTree identifierTree = (IdentifierTree)methodObject;
                NewClassTree newClassTree = this.unsecuredCookies.remove(identifierTree.symbol());
                this.cookieConstructors.remove(newClassTree);
            }
        }
    }

    private void checkConstructor(NewClassTree tree) {
        if (SecureCookieCheck.isCookieClass(tree.symbolType()) && SecureCookieCheck.isSecureParamFalse(tree)) {
            this.cookieConstructors.add(tree);
        }
    }

    private static boolean isSecureParamFalse(NewClassTree newClassTree) {
        ExpressionTree secureArgument = null;
        Arguments arguments = newClassTree.arguments();
        if (CONSTRUCTORS_WITH_SECURE_PARAM_LAST.stream().anyMatch(m -> m.matches(newClassTree))) {
            secureArgument = (ExpressionTree)arguments.get(arguments.size() - 1);
        } else if (CONSTRUCTORS_WITH_SECURE_PARAM_BEFORE_LAST.stream().anyMatch(m -> m.matches(newClassTree))) {
            secureArgument = (ExpressionTree)arguments.get(arguments.size() - 2);
        } else if (CONSTRUCTORS_WITH_SECURE_PARAM_BEFORE_BEFORE_LAST.stream().anyMatch(m -> m.matches(newClassTree))) {
            secureArgument = (ExpressionTree)arguments.get(arguments.size() - 3);
        }
        if (secureArgument != null) {
            return LiteralUtils.isFalse((Tree)secureArgument);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSetSecureCall(MethodInvocationTree mit) {
        if (mit.arguments().size() != 1) return false;
        if (mit.symbol().isUnknown()) return false;
        if (mit.symbol().owner().isUnknown()) return false;
        if (!SecureCookieCheck.isCookieClass(mit.symbol().owner().type())) return false;
        if (!SETTER_NAMES.stream().anyMatch(SecureCookieCheck.getIdentifier(mit).name()::equals)) return false;
        return true;
    }

    private static boolean isCookieClass(Type type) {
        return COOKIES.stream().anyMatch(arg_0 -> ((Type)type).isSubtypeOf(arg_0));
    }

    private static IdentifierTree getIdentifier(MethodInvocationTree mit) {
        IdentifierTree id = mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) ? (IdentifierTree)mit.methodSelect() : ((MemberSelectExpressionTree)mit.methodSelect()).identifier();
        return id;
    }

    private static MethodMatcher constructorMatcher(String fullyQualifiedName) {
        return MethodMatcher.create().typeDefinition(fullyQualifiedName).name("<init>");
    }
}

