/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S3749")
public class SpringComponentWithNonAutowiredMembersCheck
extends IssuableSubscriptionVisitor {
    @RuleProperty(key="customInjectionAnnotations", description="comma-separated list of FQDN annotation names to consider as valid", defaultValue="")
    public String customInjectionAnnotations = "";

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree clazzTree = (ClassTree)tree;
        SymbolMetadata clazzMeta = clazzTree.symbol().metadata();
        if (SpringComponentWithNonAutowiredMembersCheck.isSpringComponent(clazzMeta) && !SpringComponentWithNonAutowiredMembersCheck.hasUniqueConstructor(clazzTree)) {
            clazzTree.members().stream().filter(v -> v.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(m -> (VariableTree)m).filter(v -> !v.symbol().isStatic()).filter(v -> !SpringComponentWithNonAutowiredMembersCheck.isSpringInjectionAnnotated(v.symbol().metadata())).filter(v -> !this.isCustomInjectionAnnotated(v.symbol().metadata())).forEach(v -> this.reportIssue((Tree)v.simpleName(), "Annotate this member with \"@Autowired\", \"@Resource\", \"@Inject\", or \"@Value\", or remove it."));
        }
    }

    private static boolean hasUniqueConstructor(ClassTree clazzTree) {
        return clazzTree.symbol().memberSymbols().stream().filter(Symbol::isMethodSymbol).map(s -> (Symbol.MethodSymbol)s).filter(m -> m.name().equals("<init>")).filter(m -> m.declaration() != null).count() == 1L;
    }

    private static boolean isSpringInjectionAnnotated(SymbolMetadata metadata) {
        return metadata.isAnnotatedWith("org.springframework.beans.factory.annotation.Autowired") || metadata.isAnnotatedWith("javax.inject.Inject") || metadata.isAnnotatedWith("javax.annotation.Resource") || metadata.isAnnotatedWith("org.springframework.beans.factory.annotation.Value");
    }

    private boolean isCustomInjectionAnnotated(SymbolMetadata metadata) {
        return Splitter.on((String)",").trimResults().splitToList((CharSequence)this.customInjectionAnnotations).stream().anyMatch(arg_0 -> ((SymbolMetadata)metadata).isAnnotatedWith(arg_0));
    }

    private static boolean isSpringComponent(SymbolMetadata clazzMeta) {
        return clazzMeta.isAnnotatedWith("org.springframework.stereotype.Controller") || clazzMeta.isAnnotatedWith("org.springframework.stereotype.Service") || clazzMeta.isAnnotatedWith("org.springframework.stereotype.Repository");
    }
}

