/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ConstantUtils;
import org.sonar.java.checks.helpers.ReassignmentFinder;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2077")
public class SQLInjectionCheck
extends IssuableSubscriptionVisitor {
    private static final String JAVA_SQL_STATEMENT = "java.sql.Statement";
    private static final String JAVA_SQL_CONNECTION = "java.sql.Connection";
    private static final String SPRING_JDBC_OPERATIONS = "org.springframework.jdbc.core.JdbcOperations";
    private static final MethodMatcherCollection SQL_INJECTION_SUSPECTS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{MethodMatcher.create().callSite(TypeCriteria.subtypeOf((String)"org.hibernate.Session")).name("createQuery").withAnyParameters(), MethodMatcher.create().callSite(TypeCriteria.subtypeOf((String)"org.hibernate.Session")).name("createSQLQuery").withAnyParameters(), SQLInjectionCheck.matcherBuilder("java.sql.Statement").name("executeQuery").withAnyParameters(), SQLInjectionCheck.matcherBuilder("java.sql.Statement").name("execute").withAnyParameters(), SQLInjectionCheck.matcherBuilder("java.sql.Statement").name("executeUpdate").withAnyParameters(), SQLInjectionCheck.matcherBuilder("java.sql.Statement").name("executeLargeUpdate").withAnyParameters(), SQLInjectionCheck.matcherBuilder("java.sql.Statement").name("addBatch").withAnyParameters(), SQLInjectionCheck.matcherBuilder("java.sql.Connection").name("prepareStatement").withAnyParameters(), SQLInjectionCheck.matcherBuilder("java.sql.Connection").name("prepareCall").withAnyParameters(), SQLInjectionCheck.matcherBuilder("java.sql.Connection").name("nativeSQL").withAnyParameters(), MethodMatcher.create().typeDefinition("javax.persistence.EntityManager").name("createNativeQuery").withAnyParameters(), MethodMatcher.create().typeDefinition("javax.persistence.EntityManager").name("createQuery").withAnyParameters(), SQLInjectionCheck.matcherBuilder("org.springframework.jdbc.core.JdbcOperations").name("batchUpdate").withAnyParameters(), SQLInjectionCheck.matcherBuilder("org.springframework.jdbc.core.JdbcOperations").name("execute").withAnyParameters(), SQLInjectionCheck.matcherBuilder("org.springframework.jdbc.core.JdbcOperations").name("query").withAnyParameters(), SQLInjectionCheck.matcherBuilder("org.springframework.jdbc.core.JdbcOperations").name("queryForList").withAnyParameters(), SQLInjectionCheck.matcherBuilder("org.springframework.jdbc.core.JdbcOperations").name("queryForMap").withAnyParameters(), SQLInjectionCheck.matcherBuilder("org.springframework.jdbc.core.JdbcOperations").name("queryForObject").withAnyParameters(), SQLInjectionCheck.matcherBuilder("org.springframework.jdbc.core.JdbcOperations").name("queryForRowSet").withAnyParameters(), SQLInjectionCheck.matcherBuilder("org.springframework.jdbc.core.JdbcOperations").name("queryForInt").withAnyParameters(), SQLInjectionCheck.matcherBuilder("org.springframework.jdbc.core.JdbcOperations").name("queryForLong").withAnyParameters(), SQLInjectionCheck.matcherBuilder("org.springframework.jdbc.core.JdbcOperations").name("update").withAnyParameters(), MethodMatcher.create().typeDefinition("org.springframework.jdbc.core.PreparedStatementCreatorFactory").name("<init>").withAnyParameters(), MethodMatcher.create().typeDefinition("org.springframework.jdbc.core.PreparedStatementCreatorFactory").name("newPreparedStatementCreator").withAnyParameters(), SQLInjectionCheck.matcherBuilder("javax.jdo.PersistenceManager").name("newQuery").withAnyParameters(), SQLInjectionCheck.matcherBuilder("javax.jdo.Query").name("setFilter").withAnyParameters(), SQLInjectionCheck.matcherBuilder("javax.jdo.Query").name("setGrouping").withAnyParameters()});

    private static MethodMatcher matcherBuilder(String typeFQN) {
        return MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)typeFQN));
    }

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        if (SQLInjectionCheck.anyMatch(tree)) {
            Optional<ExpressionTree> sqlStringArg = SQLInjectionCheck.arguments(tree).filter(arg -> arg.symbolType().is("java.lang.String")).findFirst();
            sqlStringArg.filter(SQLInjectionCheck::isDynamicString).ifPresent(arg -> this.reportIssue((Tree)arg, "Ensure that string concatenation is required and safe for this SQL query."));
        }
    }

    private static Stream<ExpressionTree> arguments(Tree methodTree) {
        if (methodTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return ((MethodInvocationTree)methodTree).arguments().stream();
        }
        if (methodTree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            return ((NewClassTree)methodTree).arguments().stream();
        }
        return Stream.empty();
    }

    private static boolean anyMatch(Tree tree) {
        if (!SQLInjectionCheck.hasArguments(tree)) {
            return false;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            return SQL_INJECTION_SUSPECTS.anyMatch((NewClassTree)tree);
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return SQL_INJECTION_SUSPECTS.anyMatch((MethodInvocationTree)tree);
        }
        return false;
    }

    private static boolean hasArguments(Tree tree) {
        return SQLInjectionCheck.arguments(tree).findAny().isPresent();
    }

    private static boolean isDynamicString(ExpressionTree arg) {
        if (arg.is(new Tree.Kind[]{Tree.Kind.PLUS_ASSIGNMENT})) {
            return ConstantUtils.resolveAsConstant(((AssignmentExpressionTree)arg).expression()) == null;
        }
        if (arg.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol symbol = ((IdentifierTree)arg).symbol();
            ExpressionTree initializerOrExpression = ReassignmentFinder.getInitializerOrExpression(symbol.declaration());
            return initializerOrExpression != null && SQLInjectionCheck.isDynamicString(initializerOrExpression) || ReassignmentFinder.getReassignments(symbol.owner().declaration(), symbol.usages()).stream().anyMatch(SQLInjectionCheck::isDynamicString);
        }
        return arg.is(new Tree.Kind[]{Tree.Kind.PLUS}) && ConstantUtils.resolveAsConstant(arg) == null;
    }
}

