/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4423")
public class WeakSSLContextCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> STRONG_PROTOCOLS = new HashSet<String>(Arrays.asList("TLSv1.2", "DTLSv1.2", "TLSv1.3", "DTLSv1.3"));
    private static final Set<String> STRONG_AFTER_JAVA_8 = new HashSet<String>(Arrays.asList("TLS", "DTLS"));
    private static final MethodMatcher SSLCONTEXT_GETINSTANCE_MATCHER = MethodMatcher.create().typeDefinition("javax.net.ssl.SSLContext").name("getInstance").withAnyParameters();
    private boolean projectHasJava8OrHigher;

    public void setContext(JavaFileScannerContext context) {
        this.projectHasJava8OrHigher = context.getJavaVersion().asInt() >= 8;
        super.setContext(context);
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        String protocol;
        ExpressionTree firstArgument;
        if (!this.hasSemantic()) {
            return;
        }
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        Arguments arguments = mit.arguments();
        if (SSLCONTEXT_GETINSTANCE_MATCHER.matches(mit) && (firstArgument = (ExpressionTree)arguments.get(0)).is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && !this.isStrongProtocol(protocol = LiteralUtils.trimQuotes((String)((LiteralTree)firstArgument).value()))) {
            this.reportIssue((Tree)firstArgument, "Change this code to use a stronger protocol.");
        }
    }

    private boolean isStrongProtocol(String protocol) {
        return STRONG_PROTOCOLS.contains(protocol) || this.projectHasJava8OrHigher && STRONG_AFTER_JAVA_8.contains(protocol);
    }
}

