/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5322")
public class ReceivingIntentsCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Collections.singletonList(MethodMatcher.create().typeDefinition("android.content.Context").name("registerReceiver").withAnyParameters());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (mit.arguments().size() < 4 || ((ExpressionTree)mit.arguments().get(2)).is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            this.reportIssue((Tree)mit.methodSelect(), "Make sure that intents are received safely here.");
        }
    }
}

