/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.JavaVersion;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S1610")
public class AbstractClassNoFieldShouldBeInterfaceCheck
extends IssuableSubscriptionVisitor
implements JavaVersionAwareVisitor {
    private int javaVersionAsInt;

    public boolean isCompatibleWithJavaVersion(JavaVersion version) {
        return version.isJava8Compatible();
    }

    public void scanFile(JavaFileScannerContext context) {
        this.javaVersionAsInt = context.getJavaVersion().asInt();
        super.scanFile(context);
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (classTree.superClass() == null && AbstractClassNoFieldShouldBeInterfaceCheck.classIsAbstract(classTree) && AbstractClassNoFieldShouldBeInterfaceCheck.classHasNoFieldAndProtectedMethod(classTree) && AbstractClassNoFieldShouldBeInterfaceCheck.classHasNoAutoValueOrImmutableAnnotation(classTree) && this.supportPrivateMethod(classTree)) {
            IdentifierTree simpleName = classTree.simpleName();
            this.reportIssue((Tree)simpleName, "Convert the abstract class \"" + simpleName.name() + "\" into an interface." + this.context.getJavaVersion().java8CompatibilityMessage());
        }
    }

    private static boolean classIsAbstract(ClassTree tree) {
        return ModifiersUtils.hasModifier((ModifiersTree)tree.modifiers(), (Modifier)Modifier.ABSTRACT);
    }

    private boolean supportPrivateMethod(ClassTree tree) {
        return !AbstractClassNoFieldShouldBeInterfaceCheck.hasPrivateMethod(tree) || this.javaVersionAsInt >= 9;
    }

    private static boolean hasPrivateMethod(ClassTree tree) {
        return tree.members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.METHOD})).anyMatch(member -> ModifiersUtils.hasModifier((ModifiersTree)((MethodTree)member).modifiers(), (Modifier)Modifier.PRIVATE));
    }

    private static boolean classHasNoFieldAndProtectedMethod(ClassTree tree) {
        return tree.members().stream().noneMatch(member -> member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || member.is(new Tree.Kind[]{Tree.Kind.METHOD}) && AbstractClassNoFieldShouldBeInterfaceCheck.isProtectedOrOverriding((MethodTree)member));
    }

    private static boolean isProtectedOrOverriding(MethodTree member) {
        return ModifiersUtils.hasModifier((ModifiersTree)member.modifiers(), (Modifier)Modifier.PROTECTED) || !Boolean.FALSE.equals(member.isOverriding());
    }

    private static boolean classHasNoAutoValueOrImmutableAnnotation(ClassTree tree) {
        return tree.modifiers().annotations().stream().map(AnnotationTree::annotationType).map(TypeTree::symbolType).noneMatch(type -> type.is("com.google.auto.value.AutoValue") || type.is("org.immutables.value.Value$Immutable"));
    }
}

