/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

public abstract class AbstractInjectionChecker
extends IssuableSubscriptionVisitor {
    protected String parameterName;
    private SemanticModel semanticModel;

    public void scanFile(JavaFileScannerContext context) {
        this.semanticModel = (SemanticModel)context.getSemanticModel();
        super.scanFile(context);
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION);
    }

    protected boolean isDynamicString(Tree methodTree, ExpressionTree arg, @Nullable Symbol currentlyChecking) {
        return this.isDynamicString(methodTree, arg, currentlyChecking, false);
    }

    protected boolean isDynamicString(Tree methodTree, ExpressionTree arg, @Nullable Symbol currentlyChecking, boolean firstLevel) {
        if (arg.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)arg;
            IdentifierTree identifier = memberSelectExpressionTree.identifier();
            if (ExpressionUtils.isSelectOnThisOrSuper((MemberSelectExpressionTree)memberSelectExpressionTree)) {
                return this.isIdentifierDynamicString(methodTree, identifier, currentlyChecking, firstLevel);
            }
            return !this.isConstant(identifier.symbol());
        }
        if (arg.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return this.isIdentifierDynamicString(methodTree, (IdentifierTree)arg, currentlyChecking, firstLevel);
        }
        if (arg.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            BinaryExpressionTree binaryArg = (BinaryExpressionTree)arg;
            return this.isDynamicString(methodTree, binaryArg.rightOperand(), currentlyChecking) || this.isDynamicString(methodTree, binaryArg.leftOperand(), currentlyChecking);
        }
        if (arg.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return false;
        }
        return !arg.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL, Tree.Kind.NULL_LITERAL});
    }

    protected boolean isIdentifierDynamicString(Tree methodTree, IdentifierTree arg, @Nullable Symbol currentlyChecking, boolean firstLevel) {
        boolean isLocalVar;
        Symbol symbol = arg.symbol();
        if (this.isExcluded(currentlyChecking, symbol)) {
            return false;
        }
        boolean bl = isLocalVar = symbol.owner().isMethodSymbol() && !((JavaSymbol.MethodJavaSymbol)symbol.owner()).getParameters().scopeSymbols().contains(symbol);
        if (isLocalVar) {
            VariableTree declaration = ((Symbol.VariableSymbol)symbol).declaration();
            ExpressionTree initializer = declaration.initializer();
            if (initializer != null && this.isDynamicString(methodTree, initializer, currentlyChecking)) {
                return true;
            }
            List usages = symbol.usages();
            LocalVariableDynamicStringVisitor visitor = new LocalVariableDynamicStringVisitor(symbol, usages, methodTree);
            Tree argEnclosingDeclarationTree = this.semanticModel.getTree(this.semanticModel.getEnv(symbol));
            argEnclosingDeclarationTree.accept((TreeVisitor)visitor);
            return visitor.dynamicString;
        }
        this.parameterName = "\"" + arg.name() + "\"";
        return symbol.owner().isMethodSymbol() && !firstLevel;
    }

    private boolean isExcluded(@Nullable Symbol currentlyChecking, Symbol symbol) {
        return !symbol.isVariableSymbol() || symbol.equals(currentlyChecking) || this.isConstant(symbol);
    }

    public boolean isConstant(Symbol symbol) {
        return symbol.isStatic() && symbol.isFinal();
    }

    protected void setParameterNameFromArgument(ExpressionTree arg) {
        if (arg.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.parameterName = "\"" + ((IdentifierTree)arg).name() + "\"";
        } else if (arg.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            this.parameterName = "\"" + ((MemberSelectExpressionTree)arg).identifier().name() + "\"";
        } else if (arg.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            this.parameterName = "result from this method";
        }
    }

    protected class LocalVariableDynamicStringVisitor
    extends BaseTreeVisitor {
        private final Collection<IdentifierTree> usages;
        private final Tree methodInvocationTree;
        private final Symbol currentlyChecking;
        boolean dynamicString;
        private boolean stopInspection;

        public LocalVariableDynamicStringVisitor(Symbol currentlyChecking, Collection<IdentifierTree> usages, Tree methodInvocationTree) {
            this.currentlyChecking = currentlyChecking;
            this.stopInspection = false;
            this.usages = usages;
            this.methodInvocationTree = methodInvocationTree;
            this.dynamicString = false;
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            if (!this.stopInspection && tree.variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && this.usages.contains(tree.variable())) {
                this.dynamicString |= AbstractInjectionChecker.this.isDynamicString(this.methodInvocationTree, tree.expression(), this.currentlyChecking);
            }
            super.visitAssignmentExpression(tree);
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (tree.equals(this.methodInvocationTree)) {
                this.stopInspection = true;
            } else {
                super.visitMethodInvocation(tree);
            }
        }

        public void visitNewClass(NewClassTree tree) {
            if (tree.equals(this.methodInvocationTree)) {
                this.stopInspection = true;
            } else {
                super.visitNewClass(tree);
            }
        }
    }
}

