/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ConstantUtils;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3011")
public class AccessibilityChangeCheck
extends AbstractMethodDetection {
    private static final String JAVA_LANG_REFLECT_FIELD = "java.lang.reflect.Field";
    private static final List<MethodMatcher> METHOD_MATCHERS = Arrays.asList(MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf((String)"java.lang.reflect.AccessibleObject")).name("setAccessible").withAnyParameters(), MethodMatcher.create().typeDefinition("java.lang.reflect.Field").name("set").withAnyParameters(), MethodMatcher.create().typeDefinition("java.lang.reflect.Field").name("setBoolean").withAnyParameters(), MethodMatcher.create().typeDefinition("java.lang.reflect.Field").name("setByte").withAnyParameters(), MethodMatcher.create().typeDefinition("java.lang.reflect.Field").name("setChar").withAnyParameters(), MethodMatcher.create().typeDefinition("java.lang.reflect.Field").name("setDouble").withAnyParameters(), MethodMatcher.create().typeDefinition("java.lang.reflect.Field").name("setFloat").withAnyParameters(), MethodMatcher.create().typeDefinition("java.lang.reflect.Field").name("setInt").withAnyParameters(), MethodMatcher.create().typeDefinition("java.lang.reflect.Field").name("setLong").withAnyParameters(), MethodMatcher.create().typeDefinition("java.lang.reflect.Field").name("setShort").withAnyParameters());

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return METHOD_MATCHERS;
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (mit.symbol().name().equals("setAccessible")) {
            this.checkAccessibilityUpdate(mit);
        } else {
            this.reportIssue((Tree)mit, "Make sure that this accessibility bypass is safe here.");
        }
    }

    private void checkAccessibilityUpdate(MethodInvocationTree mit) {
        Arguments arguments = mit.arguments();
        ExpressionTree arg = (ExpressionTree)arguments.get(0);
        if (arguments.size() > 1) {
            arg = (ExpressionTree)arguments.get(1);
        }
        if (Boolean.TRUE.equals(ConstantUtils.resolveAsBooleanConstant(arg))) {
            this.reportIssue((Tree)mit, "Make sure that this accessibility update is safe here.");
        }
    }
}

