/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.MethodJavaType;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S3878")
public class ArrayForVarArgCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        TypeTree methodName;
        Arguments args;
        Symbol sym;
        if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            NewClassTree nct = (NewClassTree)tree;
            sym = nct.constructorSymbol();
            args = nct.arguments();
            methodName = nct.identifier();
        } else {
            MethodInvocationTree mit = (MethodInvocationTree)tree;
            sym = mit.symbol();
            args = mit.arguments();
            methodName = mit.methodSelect();
        }
        if (sym.isMethodSymbol() && !args.isEmpty()) {
            ExpressionTree lastArg = (ExpressionTree)args.get(args.size() - 1);
            JavaSymbol.MethodJavaSymbol methodSymbol = (JavaSymbol.MethodJavaSymbol)sym;
            MethodJavaType methodType = ArrayForVarArgCheck.getMethodType(methodSymbol, (Tree)methodName);
            this.checkInvokedMethod(methodSymbol, methodType, lastArg);
        }
    }

    @CheckForNull
    private static MethodJavaType getMethodType(JavaSymbol.MethodJavaSymbol methodSymbol, Tree methodName) {
        if (!methodSymbol.isParametrized()) {
            return null;
        }
        Type type = null;
        if (methodName.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            type = ((MemberSelectExpressionTree)methodName).identifier().symbolType();
        } else if (methodName.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            type = ((IdentifierTree)methodName).symbolType();
        } else if (methodName.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE})) {
            type = ((ParameterizedTypeTree)methodName).symbolType();
        }
        if (type instanceof MethodJavaType) {
            return (MethodJavaType)type;
        }
        return null;
    }

    private void checkInvokedMethod(JavaSymbol.MethodJavaSymbol methodSymbol, @Nullable MethodJavaType methodType, ExpressionTree lastArg) {
        if (methodSymbol.isVarArgs() && lastArg.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            if (ArrayForVarArgCheck.lastParamHasSameType(methodSymbol, methodType, lastArg.symbolType())) {
                String message = "Remove this array creation";
                NewArrayTree newArrayTree = (NewArrayTree)lastArg;
                if (newArrayTree.openBraceToken() == null) {
                    ExpressionTree expression = ((ArrayDimensionTree)newArrayTree.dimensions().get(0)).expression();
                    Integer literalValue = LiteralUtils.intLiteralValue((ExpressionTree)expression);
                    if (literalValue == null || literalValue != 0 || ArrayForVarArgCheck.isCallingOverload(methodSymbol, lastArg)) {
                        return;
                    }
                } else if (!newArrayTree.initializers().isEmpty()) {
                    message = message + " and simply pass the elements";
                }
                this.reportIssue((Tree)lastArg, message + ".");
            } else {
                String type = ((Type.ArrayType)ArrayForVarArgCheck.getLastParameterType(methodSymbol.parameterTypes())).elementType().name();
                this.reportIssue((Tree)lastArg, "Disambiguate this call by either casting as \"" + type + "\" or \"" + type + "[]\".");
            }
        }
    }

    private static boolean isCallingOverload(JavaSymbol.MethodJavaSymbol methodSymbol, ExpressionTree lastArg) {
        MethodTree enclosing = ArrayForVarArgCheck.getEnclosingMethod(lastArg);
        return enclosing != null && ArrayForVarArgCheck.haveSameParamButLast(enclosing.symbol(), methodSymbol);
    }

    private static boolean haveSameParamButLast(Symbol.MethodSymbol enclosing, JavaSymbol.MethodJavaSymbol methodSymbol) {
        return enclosing.name().equals(methodSymbol.name()) && IntStream.range(0, enclosing.parameterTypes().size()).allMatch(i -> enclosing.parameterTypes().get(i) == methodSymbol.parameterTypes().get(i));
    }

    @CheckForNull
    private static MethodTree getEnclosingMethod(ExpressionTree lastArg) {
        Tree result;
        for (result = lastArg.parent(); result != null && !result.is(new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR}); result = result.parent()) {
        }
        return (MethodTree)result;
    }

    private static boolean lastParamHasSameType(JavaSymbol.MethodJavaSymbol methodSymbol, @Nullable MethodJavaType methodType, Type lastArgType) {
        Type lastParamType = methodType != null ? ArrayForVarArgCheck.getLastParameterType(methodType.argTypes()) : ArrayForVarArgCheck.getLastParameterType(methodSymbol.parameterTypes());
        return lastArgType.equals(lastParamType);
    }

    private static Type getLastParameterType(List<? extends Type> list) {
        return list.get(list.size() - 1);
    }
}

